/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.layout.grid.bootstrap;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.layout.component.ActionLayoutData;
import org.apache.isis.applib.layout.component.CollectionLayoutData;
import org.apache.isis.applib.layout.component.DomainObjectLayoutData;
import org.apache.isis.applib.layout.component.PropertyLayoutData;
import org.apache.isis.applib.layout.grid.bootstrap.BSElementAbstract;
import org.apache.isis.applib.layout.grid.bootstrap.BSGrid;
import org.apache.isis.applib.layout.grid.bootstrap.BSRow;
import org.apache.isis.applib.layout.grid.bootstrap.BSRowOwner;
import org.apache.isis.applib.layout.grid.bootstrap.BSTabOwner;

@XmlType(name="tab", propOrder={"name", "rows"})
public class BSTab
extends BSElementAbstract
implements BSRowOwner {
    private static final long serialVersionUID = 1L;
    private String name;
    private List<BSRow> rows = new ArrayList<BSRow>();
    private BSTabOwner owner;

    @XmlAttribute(required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    @XmlElement(name="row", required=true)
    public List<BSRow> getRows() {
        return this.rows;
    }

    public void setRows(List<BSRow> rows) {
        this.rows = rows;
    }

    @XmlTransient
    public BSTabOwner getOwner() {
        return this.owner;
    }

    public void setOwner(BSTabOwner owner) {
        this.owner = owner;
    }

    @Override
    @XmlTransient
    @Programmatic
    public BSGrid getGrid() {
        return this.getOwner().getGrid();
    }

    public String toString() {
        return "BSTab{name='" + this.name + "'}";
    }

    public static class Predicates {
        public static Predicate<BSTab> notEmpty() {
            final AtomicBoolean visitingTheNode = new AtomicBoolean(false);
            final AtomicBoolean foundContent = new AtomicBoolean(false);
            return new Predicate<BSTab>(){

                @Override
                public boolean test(final BSTab thisBsTab) {
                    BSGrid owningGrid = thisBsTab.getGrid();
                    owningGrid.visit(new BSGrid.VisitorAdapter(){

                        @Override
                        public void preVisit(BSTab bsTab) {
                            if (bsTab == thisBsTab) {
                                foundContent.set(false);
                                visitingTheNode.set(true);
                            }
                        }

                        @Override
                        public void postVisit(BSTab bsTab) {
                            if (bsTab == thisBsTab) {
                                visitingTheNode.set(false);
                            }
                        }

                        @Override
                        public void visit(DomainObjectLayoutData domainObjectLayoutData) {
                            if (visitingTheNode.get()) {
                                foundContent.set(true);
                            }
                        }

                        @Override
                        public void visit(ActionLayoutData actionLayoutData) {
                            if (visitingTheNode.get()) {
                                foundContent.set(true);
                            }
                        }

                        @Override
                        public void visit(PropertyLayoutData propertyLayoutData) {
                            if (visitingTheNode.get()) {
                                foundContent.set(true);
                            }
                        }

                        @Override
                        public void visit(CollectionLayoutData collectionLayoutData) {
                            if (visitingTheNode.get()) {
                                foundContent.set(true);
                            }
                        }
                    });
                    return foundContent.get();
                }
            };
        }
    }
}

