/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.layout.grid.bootstrap;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.layout.component.ActionLayoutData;
import org.apache.isis.applib.layout.component.CollectionLayoutData;
import org.apache.isis.applib.layout.component.DomainObjectLayoutData;
import org.apache.isis.applib.layout.component.FieldSet;
import org.apache.isis.applib.layout.component.PropertyLayoutData;
import org.apache.isis.applib.layout.grid.Grid;
import org.apache.isis.applib.layout.grid.GridAbstract;
import org.apache.isis.applib.layout.grid.bootstrap.BSClearFix;
import org.apache.isis.applib.layout.grid.bootstrap.BSCol;
import org.apache.isis.applib.layout.grid.bootstrap.BSElement;
import org.apache.isis.applib.layout.grid.bootstrap.BSRow;
import org.apache.isis.applib.layout.grid.bootstrap.BSRowContent;
import org.apache.isis.applib.layout.grid.bootstrap.BSRowOwner;
import org.apache.isis.applib.layout.grid.bootstrap.BSTab;
import org.apache.isis.applib.layout.grid.bootstrap.BSTabGroup;
import org.apache.isis.applib.layout.grid.bootstrap.BSTabGroupOwner;
import org.apache.isis.applib.layout.grid.bootstrap.BSTabOwner;
import org.apache.isis.applib.layout.grid.bootstrap.HasCssId;
import org.apache.isis.applib.mixins.dto.Dto;

@XmlRootElement(name="grid")
@XmlType(name="grid", propOrder={"rows", "metadataErrors"})
public class BSGrid
extends GridAbstract
implements BSElement,
Dto,
BSRowOwner {
    private static final long serialVersionUID = 1L;
    private String cssClass;
    private List<BSRow> rows = new ArrayList<BSRow>();
    private List<String> metadataErrors = new ArrayList<String>();
    private BSRowOwner owner;

    @Override
    @XmlAttribute(required=false)
    public String getCssClass() {
        return this.cssClass;
    }

    @Override
    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    @Override
    @XmlElement(name="row", required=true)
    public List<BSRow> getRows() {
        return this.rows;
    }

    public void setRows(List<BSRow> rows) {
        this.rows = rows;
    }

    @XmlElement(name="metadataError", required=false)
    public List<String> getMetadataErrors() {
        return this.metadataErrors;
    }

    public void setMetadataErrors(List<String> metadataErrors) {
        this.metadataErrors = metadataErrors;
    }

    @Override
    public void visit(Grid.Visitor visitor) {
        Visitor bsVisitor = BSGrid.asBsVisitor(visitor);
        bsVisitor.preVisit(this);
        bsVisitor.visit(this);
        this.traverseRows(this, visitor);
        bsVisitor.postVisit(this);
    }

    protected void traverseRows(BSRowOwner rowOwner, Grid.Visitor visitor) {
        Visitor bsVisitor = BSGrid.asBsVisitor(visitor);
        List<BSRow> rows = rowOwner.getRows();
        for (BSRow bsRow : new ArrayList<BSRow>(rows)) {
            bsRow.setOwner(this);
            bsVisitor.preVisit(bsRow);
            bsVisitor.visit(bsRow);
            this.traverseCols(visitor, bsRow);
            bsVisitor.postVisit(bsRow);
        }
    }

    private void traverseCols(Grid.Visitor visitor, BSRow bsRow) {
        Visitor bsVisitor = BSGrid.asBsVisitor(visitor);
        List<BSRowContent> cols = bsRow.getCols();
        for (BSRowContent rowContent : new ArrayList<BSRowContent>(cols)) {
            rowContent.setOwner(bsRow);
            if (rowContent instanceof BSCol) {
                BSCol bsCol = (BSCol)rowContent;
                bsVisitor.preVisit(bsCol);
                bsVisitor.visit(bsCol);
                this.traverseDomainObject(bsCol, visitor);
                this.traverseTabGroups(bsCol, visitor);
                this.traverseActions(bsCol, visitor);
                this.traverseFieldSets(bsCol, visitor);
                this.traverseCollections(bsCol, visitor);
                this.traverseRows(bsCol, visitor);
                bsVisitor.postVisit(bsCol);
                continue;
            }
            if (rowContent instanceof BSClearFix) {
                BSClearFix bsClearFix = (BSClearFix)rowContent;
                bsVisitor.visit(bsClearFix);
                continue;
            }
            throw new IllegalStateException("Unrecognized implementation of BSRowContent, " + rowContent);
        }
    }

    private void traverseDomainObject(BSCol bsCol, Grid.Visitor visitor) {
        DomainObjectLayoutData domainObject = bsCol.getDomainObject();
        if (domainObject == null) {
            return;
        }
        domainObject.setOwner(bsCol);
        visitor.visit(domainObject);
    }

    private void traverseTabGroups(BSTabGroupOwner bsTabGroupOwner, Grid.Visitor visitor) {
        Visitor bsVisitor = BSGrid.asBsVisitor(visitor);
        List<BSTabGroup> tabGroups = bsTabGroupOwner.getTabGroups();
        for (BSTabGroup bsTabGroup : new ArrayList<BSTabGroup>(tabGroups)) {
            bsTabGroup.setOwner(bsTabGroupOwner);
            bsVisitor.preVisit(bsTabGroup);
            bsVisitor.visit(bsTabGroup);
            this.traverseTabs(bsTabGroup, visitor);
            bsVisitor.postVisit(bsTabGroup);
        }
    }

    private void traverseTabs(BSTabOwner bsTabOwner, Grid.Visitor visitor) {
        Visitor bsVisitor = BSGrid.asBsVisitor(visitor);
        List<BSTab> tabs = bsTabOwner.getTabs();
        for (BSTab tab : new ArrayList<BSTab>(tabs)) {
            tab.setOwner(bsTabOwner);
            bsVisitor.preVisit(tab);
            bsVisitor.visit(tab);
            this.traverseRows(tab, visitor);
            bsVisitor.postVisit(tab);
        }
    }

    private static Visitor asBsVisitor(final Grid.Visitor visitor) {
        return visitor instanceof Visitor ? (Visitor)visitor : new VisitorAdapter(){

            @Override
            public void visit(DomainObjectLayoutData domainObjectLayoutData) {
                visitor.visit(domainObjectLayoutData);
            }

            @Override
            public void visit(ActionLayoutData actionLayoutData) {
                visitor.visit(actionLayoutData);
            }

            @Override
            public void visit(PropertyLayoutData propertyLayoutData) {
                visitor.visit(propertyLayoutData);
            }

            @Override
            public void visit(CollectionLayoutData collectionLayoutData) {
                visitor.visit(collectionLayoutData);
            }

            @Override
            public void visit(FieldSet fieldSet) {
                visitor.visit(fieldSet);
            }
        };
    }

    @Programmatic
    @XmlTransient
    public LinkedHashMap<String, BSTab> getAllTabsByName() {
        final LinkedHashMap<String, BSTab> tabsByName = new LinkedHashMap<String, BSTab>();
        this.visit(new VisitorAdapter(){

            @Override
            public void visit(BSTab bSTab) {
                tabsByName.put(bSTab.getName(), bSTab);
            }
        });
        return tabsByName;
    }

    @Programmatic
    @XmlTransient
    public LinkedHashMap<String, HasCssId> getAllCssId() {
        final LinkedHashMap<String, HasCssId> divsByCssId = new LinkedHashMap<String, HasCssId>();
        this.visit(new VisitorAdapter(){

            @Override
            public void visit(BSRow bsRow) {
                String id = bsRow.getId();
                divsByCssId.put(id, bsRow);
            }
        });
        return divsByCssId;
    }

    @Override
    @Programmatic
    @XmlTransient
    public BSGrid getGrid() {
        return this;
    }

    public static class VisitorAdapter
    extends Grid.VisitorAdapter
    implements Visitor {
        @Override
        public void preVisit(BSGrid bsGrid) {
        }

        @Override
        public void visit(BSGrid bsGrid) {
        }

        @Override
        public void postVisit(BSGrid bsGrid) {
        }

        @Override
        public void preVisit(BSRow bsRow) {
        }

        @Override
        public void visit(BSRow bsRow) {
        }

        @Override
        public void postVisit(BSRow bsRow) {
        }

        @Override
        public void preVisit(BSCol bsCol) {
        }

        @Override
        public void visit(BSCol bsCol) {
        }

        @Override
        public void postVisit(BSCol bsCol) {
        }

        @Override
        public void visit(BSClearFix bsClearFix) {
        }

        @Override
        public void preVisit(BSTabGroup bsTabGroup) {
        }

        @Override
        public void visit(BSTabGroup bsTabGroup) {
        }

        @Override
        public void postVisit(BSTabGroup bsTabGroup) {
        }

        @Override
        public void preVisit(BSTab bsTab) {
        }

        @Override
        public void visit(BSTab bsTab) {
        }

        @Override
        public void postVisit(BSTab bsTab) {
        }
    }

    public static interface Visitor
    extends Grid.Visitor {
        public void preVisit(BSGrid var1);

        public void visit(BSGrid var1);

        public void postVisit(BSGrid var1);

        public void preVisit(BSRow var1);

        public void visit(BSRow var1);

        public void postVisit(BSRow var1);

        public void preVisit(BSCol var1);

        public void visit(BSCol var1);

        public void postVisit(BSCol var1);

        public void visit(BSClearFix var1);

        public void preVisit(BSTabGroup var1);

        public void visit(BSTabGroup var1);

        public void postVisit(BSTabGroup var1);

        public void preVisit(BSTab var1);

        public void visit(BSTab var1);

        public void postVisit(BSTab var1);
    }
}

