/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.layout.grid.bootstrap;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.isis.applib.layout.component.ActionLayoutData;
import org.apache.isis.applib.layout.component.ActionLayoutDataOwner;
import org.apache.isis.applib.layout.component.CollectionLayoutData;
import org.apache.isis.applib.layout.component.CollectionLayoutDataOwner;
import org.apache.isis.applib.layout.component.DomainObjectLayoutData;
import org.apache.isis.applib.layout.component.DomainObjectLayoutDataOwner;
import org.apache.isis.applib.layout.component.FieldSet;
import org.apache.isis.applib.layout.component.FieldSetOwner;
import org.apache.isis.applib.layout.grid.bootstrap.BSRow;
import org.apache.isis.applib.layout.grid.bootstrap.BSRowContent;
import org.apache.isis.applib.layout.grid.bootstrap.BSRowOwner;
import org.apache.isis.applib.layout.grid.bootstrap.BSTabGroup;
import org.apache.isis.applib.layout.grid.bootstrap.BSTabGroupOwner;
import org.apache.isis.applib.layout.grid.bootstrap.HasCssId;
import org.apache.isis.applib.layout.grid.bootstrap.Size;
import org.apache.isis.applib.layout.grid.bootstrap.SizeSpan;
import org.apache.isis.commons.internal.primitives._Ints;

@XmlRootElement(name="col")
@XmlType(name="col", propOrder={"sizeSpans", "domainObject", "actions", "rows", "tabGroups", "fieldSets", "collections", "metadataError"})
public class BSCol
extends BSRowContent
implements ActionLayoutDataOwner,
BSTabGroupOwner,
BSRowOwner,
FieldSetOwner,
HasCssId,
CollectionLayoutDataOwner,
DomainObjectLayoutDataOwner {
    private static final long serialVersionUID = 1L;
    private static final _Ints.Range range1_12 = _Ints.Range.of((_Ints.Bound)_Ints.Bound.inclusive((int)1), (_Ints.Bound)_Ints.Bound.inclusive((int)12));
    private String id;
    private int span;
    private Boolean unreferencedActions;
    private Boolean unreferencedCollections;
    private DomainObjectLayoutData domainObject;
    private List<SizeSpan> sizeSpans = new ArrayList<SizeSpan>();
    private List<ActionLayoutData> actions = new ArrayList<ActionLayoutData>();
    private List<BSRow> rows = new ArrayList<BSRow>();
    private List<BSTabGroup> tabGroups = new ArrayList<BSTabGroup>();
    private List<FieldSet> fieldSets = new ArrayList<FieldSet>();
    private List<CollectionLayoutData> collections = new ArrayList<CollectionLayoutData>();
    private String metadataError;

    @Override
    @XmlAttribute(required=false)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlAttribute(required=true)
    public int getSpan() {
        return range1_12.bounded(this.span);
    }

    public void setSpan(int span) {
        this.span = range1_12.bounded(span);
    }

    @XmlAttribute(required=false)
    public Boolean isUnreferencedActions() {
        return this.unreferencedActions;
    }

    public void setUnreferencedActions(Boolean unreferencedActions) {
        this.unreferencedActions = unreferencedActions;
    }

    @XmlAttribute(required=false)
    public Boolean isUnreferencedCollections() {
        return this.unreferencedCollections;
    }

    public void setUnreferencedCollections(Boolean unreferencedCollections) {
        this.unreferencedCollections = unreferencedCollections;
    }

    @Override
    @XmlElementRef(type=DomainObjectLayoutData.class, name="domainObject", required=false)
    public DomainObjectLayoutData getDomainObject() {
        return this.domainObject;
    }

    @Override
    public void setDomainObject(DomainObjectLayoutData domainObjectLayoutData) {
        this.domainObject = domainObjectLayoutData;
    }

    @XmlElement(name="sizeSpan", required=false)
    public List<SizeSpan> getSizeSpans() {
        return this.sizeSpans;
    }

    public void setSizeSpans(List<SizeSpan> sizeSpans) {
        this.sizeSpans = sizeSpans;
    }

    @Override
    @XmlElementRef(type=ActionLayoutData.class, name="action", required=false)
    public List<ActionLayoutData> getActions() {
        return this.actions;
    }

    @Override
    public void setActions(List<ActionLayoutData> actions) {
        this.actions = actions;
    }

    @Override
    @XmlElement(name="row", required=false)
    public List<BSRow> getRows() {
        return this.rows;
    }

    public void setRows(List<BSRow> rows) {
        this.rows = rows;
    }

    @Override
    @XmlElement(name="tabGroup", required=false)
    public List<BSTabGroup> getTabGroups() {
        return this.tabGroups;
    }

    public void setTabGroups(List<BSTabGroup> tabGroups) {
        this.tabGroups = tabGroups;
    }

    @Override
    @XmlElementRef(type=FieldSet.class, name="fieldSet", required=false)
    public List<FieldSet> getFieldSets() {
        return this.fieldSets;
    }

    public void setFieldSets(List<FieldSet> fieldSets) {
        this.fieldSets = fieldSets;
    }

    @Override
    @XmlElementRef(type=CollectionLayoutData.class, name="collection", required=false)
    public List<CollectionLayoutData> getCollections() {
        return this.collections;
    }

    public void setCollections(List<CollectionLayoutData> collections) {
        this.collections = collections;
    }

    @XmlElement(required=false)
    public String getMetadataError() {
        return this.metadataError;
    }

    public void setMetadataError(String metadataError) {
        this.metadataError = metadataError;
    }

    public String toCssClass() {
        StringBuilder buf = new StringBuilder();
        Size size = this.getSize() != null ? this.getSize() : Size.MD;
        SizeSpan.with(size, this.getSpan()).appendCssClassFragment(buf);
        for (SizeSpan sizeSpan : this.getSizeSpans()) {
            sizeSpan.appendCssClassFragment(buf);
        }
        buf.append((String)(this.getCssClass() != null ? " " + this.getCssClass() : ""));
        return buf.toString();
    }

    public String toString() {
        return (String)(this.id != null ? "#" + this.id + " " : "") + this.toCssClass();
    }
}

