/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.layout.grid;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.layout.component.ActionLayoutData;
import org.apache.isis.applib.layout.component.ActionLayoutDataOwner;
import org.apache.isis.applib.layout.component.CollectionLayoutData;
import org.apache.isis.applib.layout.component.CollectionLayoutDataOwner;
import org.apache.isis.applib.layout.component.FieldSet;
import org.apache.isis.applib.layout.component.FieldSetOwner;
import org.apache.isis.applib.layout.component.PropertyLayoutData;
import org.apache.isis.applib.layout.grid.Grid;
import org.apache.isis.applib.layout.grid.bootstrap.BSGrid;

@XmlTransient
public abstract class GridAbstract
implements Grid {
    private Class<?> domainClass;
    private String tnsAndSchemaLocation;
    private boolean normalized;

    @Override
    @Programmatic
    @XmlTransient
    public Class<?> getDomainClass() {
        return this.domainClass;
    }

    @Override
    @Programmatic
    public void setDomainClass(Class<?> domainClass) {
        this.domainClass = domainClass;
    }

    @Override
    @Programmatic
    @XmlTransient
    public String getTnsAndSchemaLocation() {
        return this.tnsAndSchemaLocation;
    }

    @Override
    @Programmatic
    public void setTnsAndSchemaLocation(String tnsAndSchemaLocation) {
        this.tnsAndSchemaLocation = tnsAndSchemaLocation;
    }

    @Override
    @Programmatic
    @XmlTransient
    public boolean isNormalized() {
        return this.normalized;
    }

    @Override
    @Programmatic
    public void setNormalized(boolean normalized) {
        this.normalized = normalized;
    }

    protected void traverseActions(ActionLayoutDataOwner actionLayoutDataOwner, Grid.Visitor visitor) {
        List<ActionLayoutData> actionLayoutDatas = actionLayoutDataOwner.getActions();
        if (actionLayoutDatas == null) {
            return;
        }
        for (ActionLayoutData actionLayoutData : new ArrayList<ActionLayoutData>(actionLayoutDatas)) {
            actionLayoutData.setOwner(actionLayoutDataOwner);
            visitor.visit(actionLayoutData);
        }
    }

    protected void traverseFieldSets(FieldSetOwner fieldSetOwner, Grid.Visitor visitor) {
        List<FieldSet> fieldSets = fieldSetOwner.getFieldSets();
        for (FieldSet fieldSet : new ArrayList<FieldSet>(fieldSets)) {
            fieldSet.setOwner(fieldSetOwner);
            visitor.visit(fieldSet);
            this.traverseActions(fieldSet, visitor);
            List<PropertyLayoutData> properties = fieldSet.getProperties();
            for (PropertyLayoutData property : new ArrayList<PropertyLayoutData>(properties)) {
                property.setOwner(fieldSet);
                visitor.visit(property);
                this.traverseActions(property, visitor);
            }
        }
    }

    protected void traverseCollections(CollectionLayoutDataOwner owner, Grid.Visitor visitor) {
        List<CollectionLayoutData> collections = owner.getCollections();
        for (CollectionLayoutData collection : new ArrayList<CollectionLayoutData>(collections)) {
            collection.setOwner(owner);
            visitor.visit(collection);
            this.traverseActions(collection, visitor);
        }
    }

    @Override
    @Programmatic
    @XmlTransient
    public LinkedHashMap<String, PropertyLayoutData> getAllPropertiesById() {
        final LinkedHashMap<String, PropertyLayoutData> propertiesById = new LinkedHashMap<String, PropertyLayoutData>();
        this.visit(new BSGrid.VisitorAdapter(){

            @Override
            public void visit(PropertyLayoutData propertyLayoutData) {
                propertiesById.put(propertyLayoutData.getId(), propertyLayoutData);
            }
        });
        return propertiesById;
    }

    @Override
    @Programmatic
    @XmlTransient
    public LinkedHashMap<String, CollectionLayoutData> getAllCollectionsById() {
        final LinkedHashMap<String, CollectionLayoutData> collectionsById = new LinkedHashMap<String, CollectionLayoutData>();
        this.visit(new BSGrid.VisitorAdapter(){

            @Override
            public void visit(CollectionLayoutData collectionLayoutData) {
                collectionsById.put(collectionLayoutData.getId(), collectionLayoutData);
            }
        });
        return collectionsById;
    }

    @Override
    @Programmatic
    @XmlTransient
    public LinkedHashMap<String, ActionLayoutData> getAllActionsById() {
        final LinkedHashMap<String, ActionLayoutData> actionsById = new LinkedHashMap<String, ActionLayoutData>();
        this.visit(new BSGrid.VisitorAdapter(){

            @Override
            public void visit(ActionLayoutData actionLayoutData) {
                actionsById.put(actionLayoutData.getId(), actionLayoutData);
            }
        });
        return actionsById;
    }

    @Programmatic
    @XmlTransient
    public LinkedHashMap<String, FieldSet> getAllFieldSetsByName() {
        final LinkedHashMap<String, FieldSet> fieldSetsByName = new LinkedHashMap<String, FieldSet>();
        this.visit(new BSGrid.VisitorAdapter(){

            @Override
            public void visit(FieldSet fieldSet) {
                fieldSetsByName.put(fieldSet.getName(), fieldSet);
            }
        });
        return fieldSetsByName;
    }
}

