/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.jaxb;

import javax.inject.Inject;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.schema.common.v2.OidDto;

public class PersistentEntityAdapter
extends XmlAdapter<OidDto, Object> {
    @Inject
    private BookmarkService bookmarkService;

    public Object unmarshal(OidDto oidDto) throws Exception {
        Bookmark bookmark = Bookmark.forOidDto(oidDto);
        return this.bookmarkService.lookup(bookmark).orElse(null);
    }

    public OidDto marshal(Object domainObject) throws Exception {
        if (domainObject == null) {
            return null;
        }
        Bookmark bookmark = this.bookmarkService.bookmarkForElseFail(domainObject);
        return bookmark.toOidDto();
    }
}

