/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.jaxb;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.schema.common.v2.OidDto;
import org.apache.isis.schema.common.v2.OidsDto;

public class PersistentEntitiesAdapter
extends XmlAdapter<OidsDto, Iterable<Object>> {
    @Inject
    private BookmarkService bookmarkService;

    public List<Object> unmarshal(OidsDto oidsDto) {
        ArrayList<Object> domainObjects = new ArrayList<Object>();
        for (OidDto oidDto : oidsDto.getOid()) {
            Bookmark bookmark = Bookmark.forOidDto(oidDto);
            this.bookmarkService.lookup(bookmark).ifPresent(domainObjects::add);
        }
        return domainObjects;
    }

    public OidsDto marshal(Iterable<Object> domainObjects) {
        if (domainObjects == null) {
            return null;
        }
        OidsDto oidsDto = new OidsDto();
        for (Object domainObject : domainObjects) {
            Bookmark bookmark = this.getBookmarkService().bookmarkForElseFail(domainObject);
            oidsDto.getOid().add(bookmark.toOidDto());
        }
        return oidsDto;
    }

    protected BookmarkService getBookmarkService() {
        return this.bookmarkService;
    }
}

