/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.jaxb;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public final class JavaTimeJaxbAdapters {
    private static boolean isNullOrEmpty(String x) {
        return x == null || x.isEmpty();
    }

    private JavaTimeJaxbAdapters() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class PeriodToStringAdapter
    extends XmlAdapter<String, Period> {
        public Period unmarshal(String v) {
            return v != null ? Period.parse(v) : null;
        }

        public String marshal(Period v) {
            return v != null ? v.toString() : null;
        }
    }

    public static final class DurationToStringAdapter
    extends XmlAdapter<String, Duration> {
        public Duration unmarshal(String v) {
            return v != null ? Duration.parse(v) : null;
        }

        public String marshal(Duration v) {
            return v != null ? v.toString() : null;
        }
    }

    public static final class ZonedDateTimeAdapter
    extends XmlAdapter<String, ZonedDateTime> {
        public ZonedDateTime unmarshal(String v) {
            return v != null ? ZonedDateTime.parse(v) : null;
        }

        public String marshal(ZonedDateTime v) {
            return v != null ? v.toString() : null;
        }
    }

    public static final class OffsetDateTimeToStringAdapter
    extends XmlAdapter<String, OffsetDateTime> {
        public OffsetDateTime unmarshal(String v) {
            return v != null ? OffsetDateTime.parse(v) : null;
        }

        public String marshal(OffsetDateTime v) {
            return v != null ? v.toString() : null;
        }
    }

    public static final class OffsetTimeAdapter
    extends XmlAdapter<String, OffsetTime> {
        public OffsetTime unmarshal(String v) {
            return v != null ? OffsetTime.parse(v) : null;
        }

        public String marshal(OffsetTime v) {
            return v != null ? v.toString() : null;
        }
    }

    public static final class LocalDateTimeToStringAdapter
    extends XmlAdapter<String, LocalDateTime> {
        public LocalDateTime unmarshal(String v) {
            return v != null ? LocalDateTime.parse(v) : null;
        }

        public String marshal(LocalDateTime v) {
            return v != null ? v.toString() : null;
        }
    }

    public static final class LocalDateToStringAdapter
    extends XmlAdapter<String, LocalDate> {
        public LocalDate unmarshal(String v) {
            return v != null ? LocalDate.parse(v) : null;
        }

        public String marshal(LocalDate v) {
            return v != null ? v.toString() : null;
        }
    }

    public static final class LocalTimeToStringAdapter
    extends XmlAdapter<String, LocalTime> {
        public LocalTime unmarshal(String v) {
            return JavaTimeJaxbAdapters.isNullOrEmpty(v) ? null : LocalTime.parse(v);
        }

        public String marshal(LocalTime v) {
            return v != null ? v.toString() : null;
        }
    }
}

