/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.jaxb;

import java.sql.Date;
import java.sql.Timestamp;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.isis.applib.jaxb.JavaSqlXMLGregorianCalendarMarshalling;

public final class JavaSqlJaxbAdapters {
    private JavaSqlJaxbAdapters() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class TimestampToXMLGregorianCalendarAdapter
    extends XmlAdapter<XMLGregorianCalendar, Timestamp> {
        public Timestamp unmarshal(XMLGregorianCalendar timestampStr) {
            return JavaSqlXMLGregorianCalendarMarshalling.toTimestamp(timestampStr);
        }

        public XMLGregorianCalendar marshal(Timestamp timestamp) {
            return JavaSqlXMLGregorianCalendarMarshalling.toXMLGregorianCalendar(timestamp);
        }
    }

    public static final class TimestampToStringAdapter
    extends XmlAdapter<String, Timestamp> {
        public Timestamp unmarshal(String v) {
            return v != null ? new Timestamp(Long.parseLong(v)) : null;
        }

        public String marshal(Timestamp v) {
            return v != null ? Long.toString(v.getTime()) : null;
        }
    }

    public static final class DateToStringAdapter
    extends XmlAdapter<String, Date> {
        public Date unmarshal(String v) throws Exception {
            return v != null ? Date.valueOf(v) : null;
        }

        public String marshal(Date v) {
            return v != null ? v.toString() : null;
        }
    }
}

