/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.id;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Named;
import javax.persistence.Table;
import lombok.NonNull;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.Value;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.commons.internal.reflection._Annotations;
import org.springframework.lang.Nullable;

public final class LogicalType
implements Comparable<LogicalType>,
Serializable {
    private final Object $lock = new Object[0];
    private static final long serialVersionUID = 1L;
    private final Class<?> correspondingClass;
    private final Supplier<String> logicalNameProvider;
    private String logicalName;

    public static LogicalType lazy(@NonNull Class<?> correspondingClass, @NonNull Supplier<String> logicalNameProvider) {
        if (correspondingClass == null) {
            throw new NullPointerException("correspondingClass is marked non-null but is null");
        }
        if (logicalNameProvider == null) {
            throw new NullPointerException("logicalNameProvider is marked non-null but is null");
        }
        return new LogicalType(correspondingClass, logicalNameProvider);
    }

    public static LogicalType eager(@NonNull Class<?> correspondingClass, String logicalName) {
        if (correspondingClass == null) {
            throw new NullPointerException("correspondingClass is marked non-null but is null");
        }
        return new LogicalType(correspondingClass, logicalName);
    }

    public static LogicalType fqcn(@NonNull Class<?> correspondingClass) {
        if (correspondingClass == null) {
            throw new NullPointerException("correspondingClass is marked non-null but is null");
        }
        return LogicalType.eager(correspondingClass, correspondingClass.getName());
    }

    public static LogicalType infer(@NonNull Class<?> correspondingClass) {
        if (correspondingClass == null) {
            throw new NullPointerException("correspondingClass is marked non-null but is null");
        }
        String named = _Strings.emptyToNull((String)_Annotations.synthesize(correspondingClass, Named.class).map(Named::value).orElse(null));
        if (named != null) {
            return LogicalType.eager(correspondingClass, named);
        }
        String logicalTypeName = _Strings.emptyToNull((String)_Annotations.synthesize(correspondingClass, DomainObject.class).map(DomainObject::logicalTypeName).orElse(null));
        if (logicalTypeName != null) {
            return LogicalType.eager(correspondingClass, logicalTypeName);
        }
        logicalTypeName = _Strings.emptyToNull((String)_Annotations.synthesize(correspondingClass, DomainService.class).map(DomainService::logicalTypeName).orElse(null));
        if (logicalTypeName != null) {
            return LogicalType.eager(correspondingClass, logicalTypeName);
        }
        logicalTypeName = _Strings.emptyToNull((String)_Annotations.synthesize(correspondingClass, Value.class).map(Value::logicalTypeName).orElse(null));
        if (logicalTypeName != null) {
            return LogicalType.eager(correspondingClass, logicalTypeName);
        }
        logicalTypeName = _Annotations.synthesize(correspondingClass, Table.class).map(table -> _Strings.nullToEmpty((String)table.schema()).toLowerCase(Locale.ROOT) + "." + _Strings.nullToEmpty((String)table.name())).orElse(null);
        if (logicalTypeName != null && !logicalTypeName.startsWith(".") && !logicalTypeName.endsWith(".")) {
            return LogicalType.eager(correspondingClass, logicalTypeName);
        }
        return LogicalType.eager(correspondingClass, Optional.ofNullable(correspondingClass.getCanonicalName()).orElseGet(correspondingClass::getName));
    }

    private LogicalType(@NonNull Class<?> correspondingClass, @NonNull Supplier<String> logicalNameProvider) {
        if (correspondingClass == null) {
            throw new NullPointerException("correspondingClass is marked non-null but is null");
        }
        if (logicalNameProvider == null) {
            throw new NullPointerException("logicalNameProvider is marked non-null but is null");
        }
        this.correspondingClass = correspondingClass;
        this.logicalNameProvider = logicalNameProvider;
    }

    private LogicalType(@NonNull Class<?> correspondingClass, String logicalName) {
        if (correspondingClass == null) {
            throw new NullPointerException("correspondingClass is marked non-null but is null");
        }
        this.correspondingClass = correspondingClass;
        this.logicalName = this.requireNonEmpty(logicalName);
        this.logicalNameProvider = null;
    }

    public String getClassName() {
        return this.getCorrespondingClass().getCanonicalName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogicalTypeName() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.logicalName == null) {
                this.logicalName = this.requireNonEmpty(this.logicalNameProvider.get());
            }
            return this.logicalName;
        }
    }

    public String getLogicalTypeSimpleName() {
        String logicalTypeName = this.getLogicalTypeName();
        int lastDot = logicalTypeName.lastIndexOf(46);
        return lastDot >= 0 ? logicalTypeName.substring(lastDot + 1) : logicalTypeName;
    }

    public String getNamespace() {
        String logicalTypeName = this.getLogicalTypeName();
        int lastDot = logicalTypeName.lastIndexOf(46);
        return lastDot >= 0 ? logicalTypeName.substring(0, lastDot) : "";
    }

    public String getLogicalTypeNameFormatted(@NonNull String root, @NonNull String delimiter) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        if (delimiter == null) {
            throw new NullPointerException("delimiter is marked non-null but is null");
        }
        String logicalTypeName = this.getLogicalTypeName();
        int lastDot = logicalTypeName.lastIndexOf(46);
        if (lastDot > 0) {
            String namespace = logicalTypeName.substring(0, lastDot);
            String simpleTypeName = logicalTypeName.substring(lastDot + 1);
            return namespace + delimiter + simpleTypeName;
        }
        return root + logicalTypeName;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LogicalType) {
            return this.isEqualTo((LogicalType)obj);
        }
        return false;
    }

    public boolean isEqualTo(@Nullable LogicalType other) {
        if (other == null) {
            return false;
        }
        return Objects.equals(this.correspondingClass, other.correspondingClass);
    }

    public int hashCode() {
        return this.correspondingClass.hashCode();
    }

    @Override
    public int compareTo(@Nullable LogicalType other) {
        String otherClassName = other != null ? other.getCorrespondingClass().getCanonicalName() : null;
        return _Strings.compareNullsFirst((String)this.correspondingClass.getCanonicalName(), (String)otherClassName);
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private String requireNonEmpty(String logicalName) {
        if (_Strings.isEmpty((CharSequence)logicalName)) {
            throw _Exceptions.illegalArgument((String)"logical name for type %s cannot be empty", (Object[])new Object[]{this.getCorrespondingClass().getName()});
        }
        return logicalName;
    }

    public String toString() {
        return "LogicalType(correspondingClass=" + this.getCorrespondingClass() + ")";
    }

    public Class<?> getCorrespondingClass() {
        return this.correspondingClass;
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @NonNull
        private final Class<?> correspondingClass;
        @NonNull
        private final String logicalTypeName;

        private SerializationProxy(LogicalType typeIdentifier) {
            this.correspondingClass = typeIdentifier.getCorrespondingClass();
            this.logicalTypeName = typeIdentifier.getLogicalTypeName();
        }

        private Object readResolve() {
            return LogicalType.eager(this.correspondingClass, this.logicalTypeName);
        }
    }
}

