/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.graph.tree;

import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Named;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.Value;
import org.apache.isis.applib.graph.Edge;
import org.apache.isis.applib.graph.SimpleEdge;
import org.apache.isis.applib.graph.Vertex;
import org.apache.isis.applib.graph.tree.TreeAdapter;
import org.apache.isis.applib.graph.tree.TreeNode_iteratorBreadthFirst;
import org.apache.isis.applib.graph.tree.TreeNode_iteratorDepthFirst;
import org.apache.isis.applib.graph.tree.TreeNode_iteratorHierarchyUp;
import org.apache.isis.applib.graph.tree.TreePath;
import org.apache.isis.applib.graph.tree.TreeState;
import org.apache.isis.commons.internal.base._Lazy;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.springframework.lang.Nullable;

@Named(value="isis.applib.graph.tree.TreeNode")
@Value
public class TreeNode<T>
implements Vertex<T> {
    private final TreeState sharedState;
    private final T value;
    private final Class<? extends TreeAdapter<T>> treeAdapterClass;
    private final _Lazy<TreeAdapter<T>> treeAdapter = _Lazy.of(this::newTreeAdapter);
    private final _Lazy<TreePath> treePath = _Lazy.of(this::resolveTreePath);

    public static <T> TreeNode<T> of(T value, Class<? extends TreeAdapter<T>> treeAdapterClass, TreeState sharedState) {
        return new TreeNode<T>(value, treeAdapterClass, sharedState);
    }

    protected TreeNode(T value, Class<? extends TreeAdapter<T>> treeAdapterClass, TreeState sharedState) {
        this.value = Objects.requireNonNull(value);
        this.treeAdapterClass = Objects.requireNonNull(treeAdapterClass);
        this.sharedState = sharedState;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public int getIncomingCount() {
        return this.isRoot() ? 0 : 1;
    }

    @Override
    public int getOutgoingCount() {
        return this.getChildCount();
    }

    @Override
    public Stream<Edge<T>> streamIncoming() {
        return this.isRoot() ? Stream.empty() : Stream.of(SimpleEdge.of(this.getParentIfAny(), this));
    }

    @Override
    public Stream<Edge<T>> streamOutgoing() {
        return this.streamChildren().map(to -> SimpleEdge.of(this, to));
    }

    @Nullable
    public TreeNode<T> getParentIfAny() {
        return this.treeAdapter().parentOf(this.getValue()).map(this::toTreeNode).orElse(null);
    }

    public int getChildCount() {
        return this.treeAdapter().childCountOf(this.value);
    }

    public Stream<TreeNode<T>> streamChildren() {
        if (this.isLeaf()) {
            return Stream.empty();
        }
        return this.treeAdapter().childrenOf(this.value).map(this::toTreeNode);
    }

    public boolean isRoot() {
        return this.getParentIfAny() == null;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public TreePath getPositionAsPath() {
        return (TreePath)this.treePath.get();
    }

    public TreeState getTreeState() {
        return this.sharedState;
    }

    public boolean isExpanded(TreePath treePath) {
        Set<TreePath> expandedPaths = this.getTreeState().getExpandedNodePaths();
        return expandedPaths.contains(treePath);
    }

    @Programmatic
    public void expand(TreePath ... treePaths) {
        Set<TreePath> expandedPaths = this.getTreeState().getExpandedNodePaths();
        _NullSafe.stream((Object[])treePaths).forEach(expandedPaths::add);
    }

    @Programmatic
    public void expand() {
        Set<TreePath> expandedPaths = this.getTreeState().getExpandedNodePaths();
        this.streamHierarchyUp().map(TreeNode::getPositionAsPath).forEach(expandedPaths::add);
    }

    @Programmatic
    public void collapse(TreePath ... treePaths) {
        Set<TreePath> expandedPaths = this.getTreeState().getExpandedNodePaths();
        _NullSafe.stream((Object[])treePaths).forEach(expandedPaths::remove);
    }

    public static <T> TreeNode<T> lazy(T node, Class<? extends TreeAdapter<T>> treeAdapterClass) {
        return TreeNode.of(node, treeAdapterClass, TreeState.rootCollapsed());
    }

    public Iterator<TreeNode<T>> iteratorHierarchyUp() {
        return new TreeNode_iteratorHierarchyUp(this);
    }

    public Stream<TreeNode<T>> streamHierarchyUp() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iteratorHierarchyUp(), 16), false);
    }

    public Iterator<TreeNode<T>> iteratorDepthFirst() {
        return new TreeNode_iteratorDepthFirst(this);
    }

    public Iterator<TreeNode<T>> iteratorBreadthFirst() {
        return new TreeNode_iteratorBreadthFirst(this);
    }

    public Stream<TreeNode<T>> streamDepthFirst() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iteratorDepthFirst(), 16), false);
    }

    public Stream<TreeNode<T>> streamBreadthFirst() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iteratorBreadthFirst(), 16), false);
    }

    public Class<? extends TreeAdapter<T>> getTreeAdapterClass() {
        return this.treeAdapterClass;
    }

    private TreeAdapter<T> newTreeAdapter() {
        try {
            return this.treeAdapterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(String.format("failed to instantiate TreeAdapter '%s'", this.treeAdapterClass.getName()), e);
        }
    }

    private TreeAdapter<T> treeAdapter() {
        return (TreeAdapter)this.treeAdapter.get();
    }

    private TreeNode<T> toTreeNode(T value) {
        return TreeNode.of(value, this.getTreeAdapterClass(), this.sharedState);
    }

    private TreePath resolveTreePath() {
        TreeNode<T> parent = this.getParentIfAny();
        if (parent == null) {
            return TreePath.root();
        }
        return parent.getPositionAsPath().append(this.indexWithinSiblings(parent));
    }

    private int indexWithinSiblings(TreeNode<T> parent) {
        LongAdder indexOneBased = new LongAdder();
        boolean found = parent.streamChildren().peek(__ -> indexOneBased.increment()).anyMatch(this::isEqualTo);
        if (!found) {
            throw _Exceptions.unexpectedCodeReach();
        }
        return indexOneBased.intValue() - 1;
    }

    private boolean isEqualTo(TreeNode<T> other) {
        if (other == null) {
            return false;
        }
        return Objects.equals(this.getValue(), other.getValue());
    }
}

