/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.graph;

import javax.inject.Named;
import org.apache.isis.applib.annotation.Value;
import org.apache.isis.applib.graph.Edge;
import org.apache.isis.applib.graph.Vertex;

@Named(value="isis.applib.graph.SimpleEdge")
@Value
public final class SimpleEdge<T>
implements Edge<T> {
    private final Vertex<T> from;
    private final Vertex<T> to;

    private SimpleEdge(Vertex<T> from, Vertex<T> to) {
        this.from = from;
        this.to = to;
    }

    public static <T> SimpleEdge<T> of(Vertex<T> from, Vertex<T> to) {
        return new SimpleEdge<T>(from, to);
    }

    @Override
    public Vertex<T> getFrom() {
        return this.from;
    }

    @Override
    public Vertex<T> getTo() {
        return this.to;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleEdge)) {
            return false;
        }
        SimpleEdge other = (SimpleEdge)o;
        Vertex<T> this$from = this.getFrom();
        Vertex<T> other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        Vertex<T> this$to = this.getTo();
        Vertex<T> other$to = other.getTo();
        return !(this$to == null ? other$to != null : !this$to.equals(other$to));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Vertex<T> $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        Vertex<T> $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        return result;
    }

    public String toString() {
        return "SimpleEdge(from=" + this.getFrom() + ", to=" + this.getTo() + ")";
    }
}

