/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.exceptions;

import org.apache.isis.applib.exceptions.TranslatableException;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.services.i18n.TranslationContext;
import org.apache.isis.commons.internal.base._Strings;

public class UnrecoverableException
extends RuntimeException
implements TranslatableException {
    private static final long serialVersionUID = 1L;
    private final TranslatableString translatableMessage;
    private final TranslationContext translationContext;

    public UnrecoverableException(String msg) {
        this(msg, null, null, null, null);
    }

    public UnrecoverableException(TranslatableString translatableMessage, Class<?> translationContextClass, String translationContextMethod) {
        this(null, translatableMessage, translationContextClass, translationContextMethod, null);
    }

    public UnrecoverableException(Throwable cause) {
        this(null, null, null, null, cause);
    }

    public UnrecoverableException(String msg, Throwable cause) {
        this(msg, null, null, null, cause);
    }

    public UnrecoverableException(TranslatableString translatableMessage, Class<?> translationContextClass, String translationContextMethod, Throwable cause) {
        this(null, translatableMessage, translationContextClass, translationContextMethod, cause);
    }

    private UnrecoverableException(String message, TranslatableString translatableMessage, Class<?> translationContextClass, String translationContextMethod, Throwable cause) {
        super(message, cause);
        this.translatableMessage = translatableMessage;
        this.translationContext = translationContextClass != null ? TranslationContext.named(translationContextClass.getName() + (String)(_Strings.isNotEmpty((CharSequence)translationContextMethod) ? "#" + translationContextMethod : "")) : TranslationContext.empty();
    }

    @Override
    public String getMessage() {
        return this.getTranslatableMessage() != null ? this.getTranslatableMessage().getPattern() : super.getMessage();
    }

    @Override
    public TranslatableString getTranslatableMessage() {
        return this.translatableMessage;
    }

    @Override
    public TranslationContext getTranslationContext() {
        return this.translationContext;
    }
}

