/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.events.metamodel;

import org.apache.isis.applib.events.metamodel.MetamodelEvent;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;

@FunctionalInterface
public interface MetamodelListener {
    public void onMetamodelLoaded();

    default public void onMetamodelAboutToBeLoaded() {
    }

    @EventListener(value={MetamodelEvent.class})
    @Order(value=0x3FFFFFFF)
    default public void onMetamodelEvent(MetamodelEvent event) {
        switch (event) {
            case BEFORE_METAMODEL_LOADING: {
                this.onMetamodelAboutToBeLoaded();
                return;
            }
            case AFTER_METAMODEL_LOADED: {
                this.onMetamodelLoaded();
                return;
            }
        }
        throw _Exceptions.unmatchedCase((Object)((Object)event));
    }
}

