/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.events.domain;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import lombok.NonNull;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.events.EventObjectBase;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.util.ObjectContracts;
import org.apache.isis.applib.util.ToString;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.springframework.lang.Nullable;

public abstract class AbstractDomainEvent<S>
extends EventObjectBase<S> {
    private Object mixedIn;
    private Phase eventPhase;
    private Identifier identifier;
    private boolean hidden;
    private String disabledReason;
    private TranslatableString disabledReasonTranslatable;
    private String invalidityReason;
    private TranslatableString invalidityReasonTranslatable;
    private final Map<Object, Object> userData = new HashMap<Object, Object>();
    private static final ToString<AbstractDomainEvent<?>> toString = ObjectContracts.toString("source", AbstractDomainEvent::getSource).thenToString("identifier", AbstractDomainEvent::getIdentifier).thenToString("eventPhase", AbstractDomainEvent::getEventPhase);

    public AbstractDomainEvent() {
        this(null, null);
    }

    public AbstractDomainEvent(S source) {
        this(source, null);
    }

    public AbstractDomainEvent(S source, Identifier identifier) {
        super(source);
        this.identifier = identifier;
    }

    @Override
    @Nullable
    public S getSource() {
        return (S)super.getSource();
    }

    public void setMixedIn(Object mixedIn) {
        this.mixedIn = mixedIn;
    }

    public <T> T getSubject() {
        Object mixedIn = this.getMixedIn();
        Object mixedInElseSource = mixedIn != null ? mixedIn : this.getSource();
        return (T)_Casts.uncheckedCast((Object)mixedInElseSource);
    }

    public void setEventPhase(Phase phase) {
        this.eventPhase = phase;
    }

    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    public void hide() {
        this.hidden = true;
    }

    public void hideIf(boolean condition) {
        if (condition) {
            this.hide();
        }
    }

    public void hideIf(@NonNull BooleanSupplier shouldHide) {
        if (shouldHide == null) {
            throw new NullPointerException("shouldHide is marked non-null but is null");
        }
        if (shouldHide.getAsBoolean()) {
            this.hide();
        }
    }

    public boolean isDisabled() {
        return this.disabledReason != null || this.disabledReasonTranslatable != null;
    }

    public void disable(String reason) {
        this.disabledReason = reason;
    }

    public void disable(TranslatableString reason) {
        this.disabledReasonTranslatable = reason;
    }

    public void disableIfReason(@NonNull Supplier<String> reasonSupplier) {
        if (reasonSupplier == null) {
            throw new NullPointerException("reasonSupplier is marked non-null but is null");
        }
        Optional.ofNullable(reasonSupplier.get()).ifPresent(this::disable);
    }

    public void disableIfTranslatableReason(@NonNull Supplier<TranslatableString> reasonSupplier) {
        if (reasonSupplier == null) {
            throw new NullPointerException("reasonSupplier is marked non-null but is null");
        }
        Optional.ofNullable(reasonSupplier.get()).ifPresent(this::disable);
    }

    public boolean isInvalid() {
        return this.invalidityReason != null || this.invalidityReasonTranslatable != null;
    }

    public void invalidate(String reason) {
        this.invalidityReason = reason;
    }

    public void invalidate(TranslatableString reason) {
        this.invalidityReasonTranslatable = reason;
    }

    public void invalidateIfReason(@NonNull Supplier<String> reasonSupplier) {
        if (reasonSupplier == null) {
            throw new NullPointerException("reasonSupplier is marked non-null but is null");
        }
        Optional.ofNullable(reasonSupplier.get()).ifPresent(this::invalidate);
    }

    public void invalidateIfTranslatableReason(@NonNull Supplier<TranslatableString> reasonSupplier) {
        if (reasonSupplier == null) {
            throw new NullPointerException("reasonSupplier is marked non-null but is null");
        }
        Optional.ofNullable(reasonSupplier.get()).ifPresent(this::invalidate);
    }

    public void veto(String reason, Object ... args) {
        switch (this.getEventPhase()) {
            case HIDE: {
                this.hide();
                break;
            }
            case DISABLE: {
                if (reason == null) {
                    throw new IllegalArgumentException("Reason must be non-null");
                }
                this.disable(String.format(reason, args));
                break;
            }
            case VALIDATE: {
                if (reason == null) {
                    throw new IllegalArgumentException("Reason must be non-null");
                }
                this.invalidate(String.format(reason, args));
                break;
            }
            case EXECUTED: 
            case EXECUTING: {
                break;
            }
            default: {
                throw _Exceptions.unmatchedCase((Object)((Object)this.getEventPhase()));
            }
        }
    }

    public void veto(TranslatableString translatableReason) {
        switch (this.getEventPhase()) {
            case HIDE: {
                this.hide();
                break;
            }
            case DISABLE: {
                this.disable(translatableReason);
                break;
            }
            case VALIDATE: {
                this.invalidate(translatableReason);
                break;
            }
            case EXECUTED: 
            case EXECUTING: {
                break;
            }
            default: {
                throw _Exceptions.unmatchedCase((Object)((Object)this.getEventPhase()));
            }
        }
    }

    public Object get(Object key) {
        return this.userData.get(key);
    }

    public void put(Object key, Object value) {
        this.userData.put(key, value);
    }

    @Override
    public String toString() {
        return toString.toString(this);
    }

    public Object getMixedIn() {
        return this.mixedIn;
    }

    public Phase getEventPhase() {
        return this.eventPhase;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getDisabledReason() {
        return this.disabledReason;
    }

    public TranslatableString getDisabledReasonTranslatable() {
        return this.disabledReasonTranslatable;
    }

    public String getInvalidityReason() {
        return this.invalidityReason;
    }

    public TranslatableString getInvalidityReasonTranslatable() {
        return this.invalidityReasonTranslatable;
    }

    public static enum Phase {
        HIDE,
        DISABLE,
        VALIDATE,
        EXECUTING,
        EXECUTED;


        public boolean isValidatingOrLater() {
            return this == VALIDATE || this.isExecutingOrLater();
        }

        public boolean isExecutingOrLater() {
            return this.isExecuting() || this.isExecuted();
        }

        public boolean isExecuting() {
            return this == EXECUTING;
        }

        public boolean isExecuted() {
            return this == EXECUTED;
        }
    }
}

