/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.events;

import lombok.NonNull;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.springframework.lang.Nullable;

public abstract class EventObjectBase<T> {
    protected transient T source;

    protected EventObjectBase(@Nullable T source) {
        this.source = source;
    }

    @Nullable
    public T getSource() {
        return this.source;
    }

    public void initSource(@NonNull T source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (this.source != null) {
            throw _Exceptions.illegalState((String)(this.getClass().getName() + " cannot init when source is already set"), (Object[])new Object[0]);
        }
        this.source = source;
    }

    public String toString() {
        return this.getClass().getName() + "[source=" + this.source + "]";
    }
}

