/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.clock;

import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import javax.xml.datatype.XMLGregorianCalendar;
import lombok.NonNull;
import org.apache.isis.applib.clock.VirtualClock_frozen;
import org.apache.isis.applib.clock.VirtualClock_system;
import org.apache.isis.applib.clock.VirtualClock_withOffset;
import org.apache.isis.applib.jaxb.JavaSqlXMLGregorianCalendarMarshalling;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;

@FunctionalInterface
public interface VirtualClock
extends Serializable {
    public Instant nowAsInstant();

    public static VirtualClock system() {
        return new VirtualClock_system();
    }

    public static VirtualClock nowAt(@NonNull Instant virtualNow) {
        if (virtualNow == null) {
            throw new NullPointerException("virtualNow is marked non-null but is null");
        }
        long offsetMillis = ChronoUnit.MILLIS.between(Instant.now(), virtualNow);
        return new VirtualClock_withOffset(offsetMillis);
    }

    public static VirtualClock nowAt(@NonNull LocalDate virtualNow) {
        if (virtualNow == null) {
            throw new NullPointerException("virtualNow is marked non-null but is null");
        }
        return VirtualClock.nowAt(Instant.from(virtualNow.atStartOfDay().atZone(VirtualClock.localTimeZone())));
    }

    public static VirtualClock nowAt(@NonNull java.time.LocalDateTime virtualNow) {
        if (virtualNow == null) {
            throw new NullPointerException("virtualNow is marked non-null but is null");
        }
        return VirtualClock.nowAt(Instant.from(virtualNow.atZone(VirtualClock.localTimeZone())));
    }

    public static VirtualClock nowAt(@NonNull OffsetDateTime virtualNow) {
        if (virtualNow == null) {
            throw new NullPointerException("virtualNow is marked non-null but is null");
        }
        return VirtualClock.nowAt(Instant.from(virtualNow));
    }

    public static VirtualClock nowAt(@NonNull ZonedDateTime virtualNow) {
        if (virtualNow == null) {
            throw new NullPointerException("virtualNow is marked non-null but is null");
        }
        return VirtualClock.nowAt(Instant.from(virtualNow));
    }

    public static VirtualClock nowAt(@NonNull Date virtualNow) {
        if (virtualNow == null) {
            throw new NullPointerException("virtualNow is marked non-null but is null");
        }
        return VirtualClock.nowAt(virtualNow.toInstant());
    }

    @Deprecated
    public static VirtualClock nowAt(@NonNull org.joda.time.LocalDate virtualNow) {
        if (virtualNow == null) {
            throw new NullPointerException("virtualNow is marked non-null but is null");
        }
        return VirtualClock.nowAt(virtualNow.toDate());
    }

    @Deprecated
    public static VirtualClock nowAt(@NonNull LocalDateTime virtualNow) {
        if (virtualNow == null) {
            throw new NullPointerException("virtualNow is marked non-null but is null");
        }
        return VirtualClock.nowAt(virtualNow.toDate());
    }

    @Deprecated
    public static VirtualClock nowAt(@NonNull DateTime virtualNow) {
        if (virtualNow == null) {
            throw new NullPointerException("virtualNow is marked non-null but is null");
        }
        return VirtualClock.nowAt(virtualNow.toDate());
    }

    public static VirtualClock frozenAt(@NonNull Instant frozenAt) {
        if (frozenAt == null) {
            throw new NullPointerException("frozenAt is marked non-null but is null");
        }
        return new VirtualClock_frozen(frozenAt);
    }

    public static VirtualClock frozenAt(@NonNull LocalDate frozenAt) {
        if (frozenAt == null) {
            throw new NullPointerException("frozenAt is marked non-null but is null");
        }
        return VirtualClock.frozenAt(Instant.from(frozenAt.atStartOfDay(VirtualClock.localTimeZone())));
    }

    public static VirtualClock frozenAt(@NonNull java.time.LocalDateTime frozenAt) {
        if (frozenAt == null) {
            throw new NullPointerException("frozenAt is marked non-null but is null");
        }
        return VirtualClock.frozenAt(Instant.from(frozenAt.atZone(VirtualClock.localTimeZone())));
    }

    public static VirtualClock frozenAt(@NonNull OffsetDateTime frozenAt) {
        if (frozenAt == null) {
            throw new NullPointerException("frozenAt is marked non-null but is null");
        }
        return VirtualClock.frozenAt(Instant.from(frozenAt));
    }

    public static VirtualClock frozenAt(@NonNull ZonedDateTime frozenAt) {
        if (frozenAt == null) {
            throw new NullPointerException("frozenAt is marked non-null but is null");
        }
        return VirtualClock.frozenAt(Instant.from(frozenAt));
    }

    public static VirtualClock frozenAt(@NonNull Date frozenAt) {
        if (frozenAt == null) {
            throw new NullPointerException("frozenAt is marked non-null but is null");
        }
        return VirtualClock.frozenAt(frozenAt.toInstant());
    }

    @Deprecated
    public static VirtualClock frozenAt(@NonNull org.joda.time.LocalDate frozenAt) {
        if (frozenAt == null) {
            throw new NullPointerException("frozenAt is marked non-null but is null");
        }
        return VirtualClock.frozenAt(frozenAt.toDate());
    }

    @Deprecated
    public static VirtualClock frozenAt(@NonNull LocalDateTime frozenAt) {
        if (frozenAt == null) {
            throw new NullPointerException("frozenAt is marked non-null but is null");
        }
        return VirtualClock.frozenAt(frozenAt.toDate());
    }

    @Deprecated
    public static VirtualClock frozenAt(@NonNull DateTime frozenAt) {
        if (frozenAt == null) {
            throw new NullPointerException("frozenAt is marked non-null but is null");
        }
        return VirtualClock.frozenAt(frozenAt.toDate());
    }

    public static VirtualClock frozenTestClock() {
        Instant frozenAt = Instant.from(ZonedDateTime.of(2003, 7, 17, 21, 30, 25, 0, ZoneId.from(ZoneOffset.UTC)));
        return VirtualClock.frozenAt(frozenAt);
    }

    public static ZoneId localTimeZone() {
        return ZoneId.systemDefault();
    }

    default public long nowAsEpochMilli() {
        return this.nowAsInstant().toEpochMilli();
    }

    default public LocalDate nowAsLocalDate(@NonNull ZoneId zoneId) {
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        return this.nowAsLocalDateTime(zoneId).toLocalDate();
    }

    default public LocalDate nowAsLocalDate() {
        return this.nowAsLocalDate(VirtualClock.localTimeZone());
    }

    default public java.time.LocalDateTime nowAsLocalDateTime(@NonNull ZoneId zoneId) {
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        return java.time.LocalDateTime.ofInstant(this.nowAsInstant(), zoneId);
    }

    default public java.time.LocalDateTime nowAsLocalDateTime() {
        return this.nowAsLocalDateTime(VirtualClock.localTimeZone());
    }

    default public OffsetDateTime nowAsOffsetDateTime(@NonNull ZoneId zoneId) {
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        return OffsetDateTime.ofInstant(this.nowAsInstant(), zoneId);
    }

    default public OffsetDateTime nowAsOffsetDateTime() {
        return this.nowAsOffsetDateTime(VirtualClock.localTimeZone());
    }

    default public Date nowAsJavaUtilDate() {
        return new Date(this.nowAsEpochMilli());
    }

    default public Timestamp nowAsJavaSqlTimestamp() {
        return new Timestamp(this.nowAsEpochMilli());
    }

    default public XMLGregorianCalendar nowAsXmlGregorianCalendar() {
        return JavaSqlXMLGregorianCalendarMarshalling.toXMLGregorianCalendar(this.nowAsJavaSqlTimestamp());
    }

    @Deprecated
    default public DateTime nowAsJodaDateTime(@NonNull ZoneId zoneId) {
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        return new DateTime(this.nowAsEpochMilli(), DateTimeZone.forID((String)zoneId.getId()));
    }

    @Deprecated
    default public DateTime nowAsJodaDateTime() {
        return this.nowAsJodaDateTime(VirtualClock.localTimeZone());
    }

    @Deprecated
    default public LocalDateTime nowAsJodaLocalDateTime(@NonNull ZoneId zoneId) {
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        return this.nowAsJodaDateTime(zoneId).toLocalDateTime();
    }

    @Deprecated
    default public LocalDateTime nowAsJodaLocalDateTime() {
        return this.nowAsJodaDateTime().toLocalDateTime();
    }

    @Deprecated
    default public org.joda.time.LocalDate nowAsJodaLocalDate(@NonNull ZoneId zoneId) {
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        return new org.joda.time.LocalDate(this.nowAsEpochMilli(), DateTimeZone.forID((String)zoneId.getId()));
    }

    @Deprecated
    default public org.joda.time.LocalDate nowAsJodaLocalDate() {
        ZoneId zoneId = VirtualClock.localTimeZone();
        return this.nowAsJodaLocalDate(zoneId);
    }
}

