/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.client;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.isis.commons.internal.base._Strings;
import org.springframework.lang.Nullable;

public enum RepresentationTypeSimplifiedV2 {
    OBJECT("object"),
    OBJECT_COLLECTION("object-collection"),
    OBJECT_PROPERTY("object-property"),
    LIST("list"),
    VALUE("value"),
    VALUES("values"),
    VOID("void");

    final String typeLiteral;

    public boolean isObject() {
        return this == OBJECT;
    }

    public boolean isObjectCollection() {
        return this == OBJECT_COLLECTION;
    }

    public boolean isObjectProperty() {
        return this == OBJECT_PROPERTY;
    }

    public boolean isList() {
        return this == LIST;
    }

    public boolean isValue() {
        return this == VALUE;
    }

    public boolean isValues() {
        return this == VALUES;
    }

    public boolean isVoid() {
        return this == VOID;
    }

    public String getContentTypeHeaderValue(String profileName) {
        return "application/json;profile=\"" + profileName + "\";repr-type=\"" + this.typeLiteral + "\"";
    }

    public static Optional<RepresentationTypeSimplifiedV2> parse(@Nullable String typeLiteral) {
        return Stream.of(RepresentationTypeSimplifiedV2.values()).filter(candidate -> candidate.typeLiteral.equals(typeLiteral)).findAny();
    }

    public static Optional<RepresentationTypeSimplifiedV2> parseContentTypeHeaderString(@Nullable String contentTypeHeaderString) {
        return RepresentationTypeSimplifiedV2.extractReprType(_Strings.splitThenStream((String)contentTypeHeaderString, (String)";")).map(typeLiteral -> RepresentationTypeSimplifiedV2.parse(typeLiteral).orElse(null)).filter(Objects::nonNull);
    }

    private static String trimQuotesIfAny(String s) {
        if (s.length() < 2) {
            return s;
        }
        if (s.charAt(0) == '\"' || s.charAt(0) == '\'') {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    private static Optional<String> extractReprType(@NonNull Stream<String> stringStream) {
        if (stringStream == null) {
            throw new NullPointerException("stringStream is marked non-null but is null");
        }
        return stringStream.map(String::trim).filter(_Strings::isNotEmpty).filter(s -> s.startsWith("repr-type")).map(s -> _Strings.parseKeyValuePair((String)s, (char)'=').orElse(null)).filter(Objects::nonNull).map(Map.Entry::getValue).filter(_Strings::isNotEmpty).findAny().map(RepresentationTypeSimplifiedV2::trimQuotesIfAny);
    }

    private RepresentationTypeSimplifiedV2(String typeLiteral) {
        this.typeLiteral = typeLiteral;
    }

    public String getTypeLiteral() {
        return this.typeLiteral;
    }
}

