/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.annotation;

import javax.xml.bind.annotation.XmlType;
import org.apache.isis.applib.util.Enums;

@XmlType(namespace="http://isis.apache.org/applib/layout/component")
public enum Where {
    EVERYWHERE{

        @Override
        public boolean includes(Where context) {
            return true;
        }
    }
    ,
    ANYWHERE{

        @Override
        public boolean includes(Where context) {
            return true;
        }
    }
    ,
    OBJECT_FORMS,
    REFERENCES_PARENT,
    PARENTED_TABLES,
    STANDALONE_TABLES,
    ALL_TABLES{

        @Override
        public boolean includes(Where context) {
            return context == this || context == PARENTED_TABLES || context == STANDALONE_TABLES;
        }
    }
    ,
    ALL_EXCEPT_STANDALONE_TABLES{

        @Override
        public boolean includes(Where context) {
            return context != STANDALONE_TABLES;
        }
    }
    ,
    NOWHERE{

        @Override
        public boolean includes(Where context) {
            return false;
        }
    }
    ,
    NOT_SPECIFIED{

        @Override
        public boolean includes(Where context) {
            return false;
        }
    };


    public String getFriendlyName() {
        return Enums.getFriendlyNameOf(this);
    }

    public boolean isAlways() {
        return this == EVERYWHERE || this == ANYWHERE;
    }

    public boolean inParentedTable() {
        return this == PARENTED_TABLES || this == ALL_TABLES;
    }

    public boolean inStandaloneTable() {
        return this == STANDALONE_TABLES || this == ALL_TABLES;
    }

    public boolean includes(Where context) {
        return context == this || this.isAlways() && context.isAlways();
    }
}

