/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.annotation;

public enum Introspection {
    NOT_SPECIFIED,
    AS_CONFIGURED,
    ENCAPSULATION_ENABLED,
    ANNOTATION_REQUIRED,
    ANNOTATION_OPTIONAL;


    public boolean isNotSpecified() {
        return this == NOT_SPECIFIED;
    }

    public boolean isAsConfigured() {
        return this == AS_CONFIGURED;
    }

    public static enum SupportMethodAnnotationPolicy {
        SUPPORT_METHOD_ANNOTATIONS_REQUIRED,
        SUPPORT_METHOD_ANNOTATIONS_OPTIONAL;


        public boolean isSupportMethodAnnotationsRequired() {
            return this == SUPPORT_METHOD_ANNOTATIONS_REQUIRED;
        }
    }

    public static enum MemberAnnotationPolicy {
        MEMBER_ANNOTATIONS_REQUIRED,
        MEMBER_ANNOTATIONS_OPTIONAL;


        public boolean isMemberAnnotationsRequired() {
            return this == MEMBER_ANNOTATIONS_REQUIRED;
        }
    }

    public static enum EncapsulationPolicy {
        ONLY_PUBLIC_MEMBERS_SUPPORTED,
        ENCAPSULATED_MEMBERS_SUPPORTED;


        public boolean isEncapsulatedMembersSupported() {
            return this == ENCAPSULATED_MEMBERS_SUPPORTED;
        }
    }

    public static enum IntrospectionPolicy {
        ENCAPSULATION_ENABLED(EncapsulationPolicy.ENCAPSULATED_MEMBERS_SUPPORTED, MemberAnnotationPolicy.MEMBER_ANNOTATIONS_REQUIRED, SupportMethodAnnotationPolicy.SUPPORT_METHOD_ANNOTATIONS_REQUIRED),
        ANNOTATION_REQUIRED(EncapsulationPolicy.ONLY_PUBLIC_MEMBERS_SUPPORTED, MemberAnnotationPolicy.MEMBER_ANNOTATIONS_REQUIRED, SupportMethodAnnotationPolicy.SUPPORT_METHOD_ANNOTATIONS_OPTIONAL),
        ANNOTATION_OPTIONAL(EncapsulationPolicy.ONLY_PUBLIC_MEMBERS_SUPPORTED, MemberAnnotationPolicy.MEMBER_ANNOTATIONS_OPTIONAL, SupportMethodAnnotationPolicy.SUPPORT_METHOD_ANNOTATIONS_OPTIONAL);

        private final EncapsulationPolicy encapsulationPolicy;
        private final MemberAnnotationPolicy memberAnnotationPolicy;
        private final SupportMethodAnnotationPolicy supportMethodAnnotationPolicy;

        public EncapsulationPolicy getEncapsulationPolicy() {
            return this.encapsulationPolicy;
        }

        public MemberAnnotationPolicy getMemberAnnotationPolicy() {
            return this.memberAnnotationPolicy;
        }

        public SupportMethodAnnotationPolicy getSupportMethodAnnotationPolicy() {
            return this.supportMethodAnnotationPolicy;
        }

        private IntrospectionPolicy(EncapsulationPolicy encapsulationPolicy, MemberAnnotationPolicy memberAnnotationPolicy, SupportMethodAnnotationPolicy supportMethodAnnotationPolicy) {
            this.encapsulationPolicy = encapsulationPolicy;
            this.memberAnnotationPolicy = memberAnnotationPolicy;
            this.supportMethodAnnotationPolicy = supportMethodAnnotationPolicy;
        }
    }
}

