/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.isis.applib.id.HasLogicalType;
import org.apache.isis.applib.id.LogicalType;
import org.apache.isis.applib.services.i18n.HasTranslationContext;
import org.apache.isis.applib.services.i18n.TranslationContext;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.reflection._Reflect;

public class Identifier
implements Comparable<Identifier>,
HasLogicalType,
HasTranslationContext,
Serializable {
    private static final long serialVersionUID = 1L;
    private final LogicalType logicalType;
    private final String className;
    private final String memberLogicalName;
    private final int parameterIndex;
    private final Can<String> memberParameterClassNames;
    private final Type type;
    private final String fullIdentityString;
    private final String memberNameAndParameterClassNamesIdentityString;
    private final TranslationContext translationContext;
    private static final char SPACE = ' ';

    public static Identifier classIdentifier(LogicalType typeIdentifier) {
        return new Identifier(typeIdentifier, "", (Can<String>)Can.empty(), Type.CLASS);
    }

    public static Identifier propertyIdentifier(LogicalType typeIdentifier, String propertyOrCollectionName) {
        return new Identifier(typeIdentifier, propertyOrCollectionName, (Can<String>)Can.empty(), Type.PROPERTY);
    }

    public static Identifier collectionIdentifier(LogicalType typeIdentifier, String propertyOrCollectionName) {
        return new Identifier(typeIdentifier, propertyOrCollectionName, (Can<String>)Can.empty(), Type.COLLECTION);
    }

    public static Identifier methodIdentifier(LogicalType typeIdentifier, Method method) {
        return Identifier.actionIdentifier(typeIdentifier, _Reflect.methodToShortString((Method)method), method.getParameterTypes());
    }

    public static Identifier actionIdentifier(LogicalType typeIdentifier, String actionName, Class<?> ... parameterClasses) {
        return Identifier.actionIdentifier(typeIdentifier, actionName, Identifier.classNamesOf(parameterClasses));
    }

    public static Identifier actionIdentifier(LogicalType typeIdentifier, String actionName, Can<String> parameterClassNames) {
        return new Identifier(typeIdentifier, actionName, parameterClassNames, Type.ACTION);
    }

    private Identifier(LogicalType logicalType, String memberLogicalName, Can<String> memberParameterClassNames, Type type) {
        this(logicalType, memberLogicalName, memberParameterClassNames, type, -1);
    }

    private Identifier(LogicalType logicalType, String memberLogicalName, Can<String> memberParameterClassNames, Type type, int parameterIndex) {
        this.logicalType = logicalType;
        this.className = logicalType.getClassName();
        this.memberLogicalName = memberLogicalName;
        this.memberParameterClassNames = memberParameterClassNames;
        this.type = type;
        this.parameterIndex = parameterIndex;
        this.memberNameAndParameterClassNamesIdentityString = memberLogicalName + (String)(type.isAction() ? "(" + memberParameterClassNames.stream().collect(Collectors.joining(",")) + ")" : "");
        this.translationContext = TranslationContext.named(this.className + "#" + memberLogicalName + (type.isAction() ? "()" : ""));
        this.fullIdentityString = _Strings.isEmpty((CharSequence)memberLogicalName) ? this.className : this.className + "#" + this.memberNameAndParameterClassNamesIdentityString;
    }

    public Identifier withParameterIndex(int parameterIndex) {
        return new Identifier(this.logicalType, this.memberLogicalName, this.memberParameterClassNames, Type.ACTION_PARAMETER, parameterIndex);
    }

    public String getLogicalIdentityString(@NonNull String delimiter) {
        if (delimiter == null) {
            throw new NullPointerException("delimiter is marked non-null but is null");
        }
        return this.getLogicalTypeName() + delimiter + this.memberNameAndParameterClassNamesIdentityString;
    }

    public String getClassNaturalName() {
        String className = this.getClassName();
        String isolatedName = className.substring(className.lastIndexOf(46) + 1);
        return Identifier.naturalName(isolatedName);
    }

    public String getMemberNaturalName() {
        return Identifier.naturalName(this.memberLogicalName);
    }

    public Can<String> getMemberParameterClassNaturalNames() {
        return Identifier.naturalNames(this.memberParameterClassNames);
    }

    @Override
    public int compareTo(Identifier other) {
        return this.toString().compareTo(other.toString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Identifier) {
            return this.isEqualTo((Identifier)obj);
        }
        return false;
    }

    public boolean isEqualTo(Identifier other) {
        return Objects.equals(this.className, other.className) && Objects.equals(this.memberLogicalName, other.memberLogicalName) && this.memberParameterClassNames.equals(other.memberParameterClassNames) && this.parameterIndex == other.parameterIndex;
    }

    public int hashCode() {
        return this.fullIdentityString.hashCode();
    }

    public String toString() {
        return this.parameterIndex >= 0 ? String.format("%s[%d]", this.fullIdentityString, this.parameterIndex) : this.fullIdentityString;
    }

    private static Can<String> classNamesOf(Class<?>[] parameterClasses) {
        return Can.ofArray((Object[])parameterClasses).map(Class::getName);
    }

    private static String naturalName(String name) {
        int length = name.length();
        if (length <= 1) {
            return name.toUpperCase();
        }
        StringBuffer naturalName = new StringBuffer(length);
        char character = Character.toUpperCase(name.charAt(0));
        naturalName.append(character);
        char nextCharacter = name.charAt(1);
        for (int pos = 2; pos < length; ++pos) {
            char previousCharacter = character;
            character = nextCharacter;
            nextCharacter = name.charAt(pos);
            if (previousCharacter != ' ') {
                if (Character.isUpperCase(character) && !Character.isUpperCase(previousCharacter)) {
                    naturalName.append(' ');
                }
                if (Character.isUpperCase(character) && Character.isLowerCase(nextCharacter) && Character.isUpperCase(previousCharacter)) {
                    naturalName.append(' ');
                }
                if (Character.isDigit(character) && !Character.isDigit(previousCharacter)) {
                    naturalName.append(' ');
                }
            }
            naturalName.append(character);
        }
        naturalName.append(nextCharacter);
        return naturalName.toString();
    }

    private static Can<String> naturalNames(Can<String> names) {
        return names.map(Identifier::naturalName);
    }

    @Override
    public LogicalType getLogicalType() {
        return this.logicalType;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMemberLogicalName() {
        return this.memberLogicalName;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public Can<String> getMemberParameterClassNames() {
        return this.memberParameterClassNames;
    }

    public Type getType() {
        return this.type;
    }

    public String getFullIdentityString() {
        return this.fullIdentityString;
    }

    public String getMemberNameAndParameterClassNamesIdentityString() {
        return this.memberNameAndParameterClassNamesIdentityString;
    }

    @Override
    public TranslationContext getTranslationContext() {
        return this.translationContext;
    }

    public static enum Type {
        CLASS,
        ACTION,
        ACTION_PARAMETER,
        PROPERTY,
        COLLECTION;


        public boolean isClass() {
            return this == CLASS;
        }

        public boolean isAction() {
            return this == ACTION;
        }

        public boolean isActionParameter() {
            return this == ACTION_PARAMETER;
        }

        public boolean isProperty() {
            return this == PROPERTY;
        }

        public boolean isCollection() {
            return this == COLLECTION;
        }

        public boolean isPropertyOrCollection() {
            return this == PROPERTY || this == COLLECTION;
        }
    }
}

