/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.value;

import org.apache.isis.applib.value.Password;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class Password_Test {
    private static final String STARS = "********************";

    Password_Test() {
    }

    @Nested
    public class toString {
        @Test
        void obscures_password() {
            Password password = new Password("secret");
            Assertions.assertEquals((Object)Password_Test.STARS, (Object)password.toString());
            password = new Password("a very very very long password");
            Assertions.assertEquals((Object)Password_Test.STARS, (Object)password.toString());
        }
    }

    @Nested
    public class checkPassword {
        @Test
        void case_sensitive() {
            Password password = new Password("secret");
            Assertions.assertFalse((boolean)password.checkPassword("SECRET"));
            Assertions.assertTrue((boolean)password.checkPassword("secret"));
        }

        @Test
        void given_empty() {
            Password password = new Password("");
            Assertions.assertTrue((boolean)password.checkPassword(""));
            Assertions.assertFalse((boolean)password.checkPassword("SECRET"));
        }

        @Test
        public void given_null() {
            Password password = new Password(null);
            Assertions.assertFalse((boolean)password.checkPassword(""));
            Assertions.assertFalse((boolean)password.checkPassword("SECRET"));
            Assertions.assertTrue((boolean)password.checkPassword(null));
            Assertions.assertEquals((Object)password, (Object)new Password(null));
        }
    }
}

