/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util.schema;

import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.LongAdder;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.util.schema.InteractionDtoUtils;
import org.apache.isis.schema.cmd.v2.ParamDto;
import org.apache.isis.schema.common.v2.InteractionType;
import org.apache.isis.schema.common.v2.OidDto;
import org.apache.isis.schema.common.v2.ValueType;
import org.apache.isis.schema.common.v2.ValueWithTypeDto;
import org.apache.isis.schema.ixn.v2.ActionInvocationDto;
import org.apache.isis.schema.ixn.v2.InteractionDto;
import org.apache.isis.schema.ixn.v2.MemberExecutionDto;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.junit.Test;

public class Roundtrip {
    private final SampleValues sampleValues = new SampleValues();

    private static InteractionDto newInteractionDtoWithActionInvocation(String transactionId, int sequence, Bookmark targetBookmark, String targetTitle, String actionIdentifier, List<ParamDto> parameterDtos, String user) {
        ActionInvocationDto executionDto = InteractionDtoUtils.newActionInvocation((int)sequence, (Bookmark)targetBookmark, (String)targetTitle, (String)actionIdentifier, parameterDtos, (String)user);
        InteractionDto interactionDto = new InteractionDto();
        interactionDto.setMajorVersion("1");
        interactionDto.setMinorVersion("0");
        interactionDto.setTransactionId(transactionId);
        interactionDto.setExecution((MemberExecutionDto)executionDto);
        executionDto.setInteractionType(InteractionType.ACTION_INVOCATION);
        return interactionDto;
    }

    private static void addArg(InteractionDto interactionDto, Object sampleValue) {
        Class<?> type = sampleValue.getClass();
        String name = type.getSimpleName();
        InteractionDtoUtils.addParamArg((InteractionDto)interactionDto, (String)("a" + name), type, (Object)sampleValue, null);
        InteractionDtoUtils.addParamArg((InteractionDto)interactionDto, (String)("null" + name), type, type.cast(null), null);
    }

    private static void testArg(ActionInvocationDto invocationDto, LongAdder paramIndex, ValueType valueType, Object expectedValue) {
        Roundtrip.testArg(invocationDto, paramIndex, valueType, expectedValue, null);
    }

    private static void testArg(ActionInvocationDto invocationDto, LongAdder paramIndex, ValueType valueType, Object expectedValue, String nameOverride) {
        paramIndex.increment();
        int param = paramIndex.intValue();
        Class<?> type = expectedValue.getClass();
        String name = nameOverride != null ? nameOverride : type.getSimpleName();
        MatcherAssert.assertThat((Object)InteractionDtoUtils.getParameterName((ActionInvocationDto)invocationDto, (int)param), (Matcher)Matchers.is((Object)("a" + name)));
        MatcherAssert.assertThat((Object)InteractionDtoUtils.getParameterType((ActionInvocationDto)invocationDto, (int)param), (Matcher)Matchers.is((Object)valueType));
        MatcherAssert.assertThat((Object)InteractionDtoUtils.isNull((ActionInvocationDto)invocationDto, (int)param), (Matcher)Matchers.is((Object)false));
        Object actualValue = InteractionDtoUtils.getParameterArgValue((ActionInvocationDto)invocationDto, (int)param, type);
        if (expectedValue instanceof OidDto) {
            MatcherAssert.assertThat((Object)((OidDto)actualValue).getId(), (Matcher)Matchers.is((Object)((OidDto)expectedValue).getId()));
            MatcherAssert.assertThat((Object)((OidDto)actualValue).getType(), (Matcher)Matchers.is((Object)((OidDto)expectedValue).getType()));
        } else if (expectedValue instanceof DateTime) {
            MatcherAssert.assertThat((Object)actualValue.toString(), (Matcher)Matchers.is((Object)expectedValue.toString()));
        } else {
            MatcherAssert.assertThat((Object)actualValue, (Matcher)Matchers.is((Object)expectedValue));
        }
        paramIndex.increment();
        param = paramIndex.intValue();
        MatcherAssert.assertThat((Object)InteractionDtoUtils.getParameterName((ActionInvocationDto)invocationDto, (int)param), (Matcher)Matchers.is((Object)("null" + name)));
        MatcherAssert.assertThat((Object)InteractionDtoUtils.getParameterType((ActionInvocationDto)invocationDto, (int)param), (Matcher)Matchers.is((Object)valueType));
        MatcherAssert.assertThat((Object)InteractionDtoUtils.isNull((ActionInvocationDto)invocationDto, (int)param), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void happyCase() throws Exception {
        Timestamp startedAt = new Timestamp(new Date().getTime());
        Timestamp completedAt = new Timestamp(startedAt.getTime() + 1000L);
        ValueWithTypeDto returnDto = new ValueWithTypeDto();
        returnDto.setType(ValueType.BOOLEAN);
        returnDto.setNull(Boolean.valueOf(true));
        InteractionDto interactionDto = Roundtrip.newInteractionDtoWithActionInvocation(UUID.randomUUID().toString(), 1, Bookmark.of((String)"CUS", (String)"12345"), "John Customer", "com.mycompany.Customer#placeOrder", Arrays.asList(new ParamDto[0]), "freddyUser");
        Roundtrip.addArg(interactionDto, this.sampleValues.bookmark);
        Roundtrip.addArg(interactionDto, this.sampleValues.string);
        Roundtrip.addArg(interactionDto, this.sampleValues.primitiveByte);
        Roundtrip.addArg(interactionDto, this.sampleValues.primitiveShort);
        Roundtrip.addArg(interactionDto, this.sampleValues.primitiveInteger);
        Roundtrip.addArg(interactionDto, this.sampleValues.primitiveLong);
        Roundtrip.addArg(interactionDto, Float.valueOf(this.sampleValues.primitiveFloat));
        Roundtrip.addArg(interactionDto, this.sampleValues.primitiveDouble);
        Roundtrip.addArg(interactionDto, this.sampleValues.primitiveBoolean);
        Roundtrip.addArg(interactionDto, Character.valueOf(this.sampleValues.primitiveCharacter));
        Roundtrip.addArg(interactionDto, this.sampleValues.bigInteger);
        Roundtrip.addArg(interactionDto, this.sampleValues.bigDecimal);
        Roundtrip.addArg(interactionDto, this.sampleValues.localTime);
        Roundtrip.addArg(interactionDto, this.sampleValues.localDate);
        Roundtrip.addArg(interactionDto, this.sampleValues.localDateTime);
        Roundtrip.addArg(interactionDto, this.sampleValues.offsetTime);
        Roundtrip.addArg(interactionDto, this.sampleValues.offsetDateTime);
        Roundtrip.addArg(interactionDto, this.sampleValues.zonedDateTime);
        Roundtrip.addArg(interactionDto, this.sampleValues.jodaDateTime);
        Roundtrip.addArg(interactionDto, this.sampleValues.jodaLocalDate);
        Roundtrip.addArg(interactionDto, this.sampleValues.jodaLocalDateTime);
        Roundtrip.addArg(interactionDto, this.sampleValues.jodaLocalTime);
        CharArrayWriter caw = new CharArrayWriter();
        InteractionDtoUtils.toXml((InteractionDto)interactionDto, (Writer)caw);
        CharArrayReader reader = new CharArrayReader(caw.toCharArray());
        InteractionDto recreated = InteractionDtoUtils.fromXml((Reader)reader);
        MatcherAssert.assertThat((Object)recreated.getExecution().getMemberIdentifier(), (Matcher)Matchers.is((Object)interactionDto.getExecution().getMemberIdentifier()));
        MatcherAssert.assertThat((Object)recreated.getExecution().getTarget().getType(), (Matcher)Matchers.is((Object)interactionDto.getExecution().getTarget().getType()));
        MatcherAssert.assertThat((Object)recreated.getExecution().getTarget().getId(), (Matcher)Matchers.is((Object)interactionDto.getExecution().getTarget().getId()));
        ActionInvocationDto invocationDto = (ActionInvocationDto)recreated.getExecution();
        LongAdder paramIndex = new LongAdder();
        paramIndex.decrement();
        Roundtrip.testArg(invocationDto, paramIndex, ValueType.REFERENCE, this.sampleValues.reference, "Bookmark");
        Roundtrip.testArg(invocationDto, paramIndex, ValueType.STRING, this.sampleValues.string);
        Roundtrip.testArg(invocationDto, paramIndex, ValueType.BYTE, this.sampleValues.primitiveByte);
        Roundtrip.testArg(invocationDto, paramIndex, ValueType.SHORT, this.sampleValues.primitiveShort);
        Roundtrip.testArg(invocationDto, paramIndex, ValueType.INT, this.sampleValues.primitiveInteger);
        Roundtrip.testArg(invocationDto, paramIndex, ValueType.LONG, this.sampleValues.primitiveLong);
        Roundtrip.testArg(invocationDto, paramIndex, ValueType.FLOAT, Float.valueOf(this.sampleValues.primitiveFloat));
        Roundtrip.testArg(invocationDto, paramIndex, ValueType.DOUBLE, this.sampleValues.primitiveDouble);
        Roundtrip.testArg(invocationDto, paramIndex, ValueType.BOOLEAN, this.sampleValues.primitiveBoolean);
        Roundtrip.testArg(invocationDto, paramIndex, ValueType.CHAR, Character.valueOf(this.sampleValues.primitiveCharacter));
        Roundtrip.testArg(invocationDto, paramIndex, ValueType.BIG_INTEGER, this.sampleValues.bigInteger);
        Roundtrip.testArg(invocationDto, paramIndex, ValueType.BIG_DECIMAL, this.sampleValues.bigDecimal);
        Roundtrip.testArg(invocationDto, paramIndex, ValueType.LOCAL_TIME, this.sampleValues.localTime);
        Roundtrip.testArg(invocationDto, paramIndex, ValueType.LOCAL_DATE, this.sampleValues.localDate);
        Roundtrip.testArg(invocationDto, paramIndex, ValueType.LOCAL_DATE_TIME, this.sampleValues.localDateTime);
        Roundtrip.testArg(invocationDto, paramIndex, ValueType.OFFSET_TIME, this.sampleValues.offsetTime);
        Roundtrip.testArg(invocationDto, paramIndex, ValueType.OFFSET_DATE_TIME, this.sampleValues.offsetDateTime);
        Roundtrip.testArg(invocationDto, paramIndex, ValueType.ZONED_DATE_TIME, this.sampleValues.zonedDateTime);
        Roundtrip.testArg(invocationDto, paramIndex, ValueType.JODA_DATE_TIME, this.sampleValues.jodaDateTime);
        Roundtrip.testArg(invocationDto, paramIndex, ValueType.JODA_LOCAL_DATE, this.sampleValues.jodaLocalDate);
        Roundtrip.testArg(invocationDto, paramIndex, ValueType.JODA_LOCAL_DATE_TIME, this.sampleValues.jodaLocalDateTime);
        Roundtrip.testArg(invocationDto, paramIndex, ValueType.JODA_LOCAL_TIME, this.sampleValues.jodaLocalTime);
    }

    private static class SampleValues {
        final Bookmark bookmark = Bookmark.of((String)"ORD", (String)"12345");
        final OidDto reference = new OidDto();
        final String string = "Fred";
        final byte primitiveByte = 123;
        final short primitiveShort = 32123;
        final int primitiveInteger = 123454321;
        final long primitiveLong = 1234567654321L;
        final float primitiveFloat = 12345.679f;
        final double primitiveDouble = 1.234567890123E7;
        final boolean primitiveBoolean = true;
        final char primitiveCharacter = 'x';
        final BigInteger bigInteger;
        final BigDecimal bigDecimal;
        final java.time.LocalTime localTime;
        final OffsetTime offsetTime;
        final LocalDate localDate;
        final java.time.LocalDateTime localDateTime;
        final OffsetDateTime offsetDateTime;
        final ZonedDateTime zonedDateTime;
        final DateTime jodaDateTime;
        final org.joda.time.LocalDate jodaLocalDate;
        final LocalDateTime jodaLocalDateTime;
        final LocalTime jodaLocalTime;

        private SampleValues() {
            this.reference.setId("12345");
            this.reference.setType("ORD");
            this.string = "Fred";
            this.primitiveByte = (byte)123;
            this.primitiveShort = (short)32123;
            this.primitiveInteger = 123454321;
            this.primitiveLong = 1234567654321L;
            this.primitiveFloat = 12345.679f;
            this.primitiveDouble = 1.234567890123E7;
            this.primitiveBoolean = true;
            this.primitiveCharacter = (char)120;
            this.bigInteger = new BigInteger("12345678901234567890");
            this.bigDecimal = new BigDecimal("12345678901234567890");
            this.localTime = java.time.LocalTime.of(9, 54, 1);
            this.offsetTime = OffsetTime.of(9, 54, 1, 123000000, ZoneOffset.ofTotalSeconds(-120));
            this.localDate = LocalDate.of(2015, 5, 23);
            this.localDateTime = java.time.LocalDateTime.of(2015, 5, 23, 9, 54, 1);
            this.offsetDateTime = OffsetDateTime.of(2015, 5, 23, 9, 54, 1, 0, ZoneOffset.UTC);
            this.zonedDateTime = ZonedDateTime.of(2015, 5, 23, 9, 54, 1, 0, ZoneOffset.UTC);
            this.jodaDateTime = new DateTime(2015, 5, 23, 9, 54, 1);
            this.jodaLocalDate = new org.joda.time.LocalDate(2015, 5, 23);
            this.jodaLocalDateTime = new LocalDateTime(2015, 5, 23, 9, 54, 1);
            this.jodaLocalTime = new LocalTime(9, 54, 1);
        }
    }
}

