/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util.schema;

import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.applib.util.schema.CommonDtoUtils;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.schema.common.v2.BlobDto;
import org.apache.isis.schema.common.v2.ClobDto;
import org.apache.isis.schema.common.v2.ValueDto;
import org.apache.isis.schema.common.v2.ValueType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jmock.auto.Mock;
import org.jmock.integration.junit4.JUnitRuleMockery;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class CommonDtoUtils_setValueOn_Test {
    @Rule
    public JUnitRuleMockery context = new JUnitRuleMockery();
    @Mock
    private BookmarkService mockBookmarkService;
    ValueDto valueDto;

    @Before
    public void setUp() throws Exception {
        this.valueDto = new ValueDto();
    }

    @Test
    public void when_blob_is_null() {
        CommonDtoUtils.setValueOn((ValueDto)this.valueDto, (ValueType)ValueType.BLOB, null, (BookmarkService)this.mockBookmarkService);
        BlobDto blobDto = this.valueDto.getBlob();
        Assert.assertThat((Object)blobDto, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void when_blob_is_not_null() {
        Blob val = new Blob("image.png", "image/png", new byte[]{1, 2, 3, 4, 5});
        CommonDtoUtils.setValueOn((ValueDto)this.valueDto, (ValueType)ValueType.BLOB, (Object)val, (BookmarkService)this.mockBookmarkService);
        BlobDto blobDto = this.valueDto.getBlob();
        Assert.assertThat((Object)blobDto, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)blobDto.getBytes(), (Matcher)CoreMatchers.is((Object)val.getBytes()));
        Assert.assertThat((Object)blobDto.getName(), (Matcher)CoreMatchers.is((Object)val.getName()));
        Assert.assertThat((Object)blobDto.getMimeType(), (Matcher)CoreMatchers.is((Object)val.getMimeType().toString()));
    }

    @Test
    public void when_clob_is_null() {
        CommonDtoUtils.setValueOn((ValueDto)this.valueDto, (ValueType)ValueType.CLOB, null, (BookmarkService)this.mockBookmarkService);
        ClobDto clobDto = this.valueDto.getClob();
        Assert.assertThat((Object)clobDto, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void when_clob_is_not_null() {
        Clob val = new Clob("image.png", "image/png", new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005'});
        CommonDtoUtils.setValueOn((ValueDto)this.valueDto, (ValueType)ValueType.CLOB, (Object)val, (BookmarkService)this.mockBookmarkService);
        ClobDto clobDto = this.valueDto.getClob();
        Assert.assertThat((Object)clobDto, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)clobDto.getChars(), (Matcher)CoreMatchers.is((Object)val.getChars()));
        Assert.assertThat((Object)clobDto.getName(), (Matcher)CoreMatchers.is((Object)val.getName()));
        Assert.assertThat((Object)clobDto.getMimeType(), (Matcher)CoreMatchers.is((Object)val.getMimeType().toString()));
    }
}

