/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util.schema;

import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.applib.util.schema.CommonDtoUtils;
import org.apache.isis.applib.util.schema.Vertical;
import org.apache.isis.schema.cmd.v2.MapDto;
import org.apache.isis.schema.common.v2.ValueDto;
import org.apache.isis.schema.common.v2.ValueType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jmock.auto.Mock;
import org.jmock.integration.junit4.JUnitRuleMockery;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class CommonDtoUtils_Test {
    @Rule
    public JUnitRuleMockery context = new JUnitRuleMockery();
    @Mock
    private BookmarkService mockBookmarkService;

    @Test
    public void enums() {
        this.test(Vertical.DOWN);
    }

    @Test
    public void nested_enums() {
        this.test(Horizontal.LEFT);
    }

    private void test(Enum<?> enumVal) {
        ValueType valueType = CommonDtoUtils.asValueType(enumVal.getClass());
        MatcherAssert.assertThat((Object)valueType, (Matcher)CoreMatchers.is((Object)ValueType.ENUM));
        ValueDto valueDto = CommonDtoUtils.newValueDto((ValueType)valueType, enumVal, (BookmarkService)this.mockBookmarkService);
        Object value = CommonDtoUtils.getValue((ValueDto)valueDto, (ValueType)valueType);
        MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertEquals((Object)value, enumVal);
    }

    @Test
    public void getMapValue() {
        Assert.assertThat((Object)CommonDtoUtils.getMapValue(null, (String)"someKey"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)CommonDtoUtils.getMapValue((MapDto)new MapDto(), (String)"someKey"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MapDto mapDto = new MapDto();
        MapDto.Entry e = new MapDto.Entry();
        e.setKey("someKey");
        e.setValue("someValue");
        mapDto.getEntry().add(e);
        Assert.assertThat((Object)CommonDtoUtils.getMapValue((MapDto)mapDto, (String)"someKey"), (Matcher)CoreMatchers.is((Object)"someValue"));
        Assert.assertThat((Object)CommonDtoUtils.getMapValue((MapDto)mapDto, (String)"someThingElse"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void putMapKeyValue() {
        CommonDtoUtils.putMapKeyValue(null, (String)"someKey", (String)"someValue");
        MapDto mapDto = new MapDto();
        CommonDtoUtils.putMapKeyValue((MapDto)mapDto, (String)"someKey", (String)"someValue");
        Assert.assertThat((Object)CommonDtoUtils.getMapValue((MapDto)mapDto, (String)"someKey"), (Matcher)CoreMatchers.is((Object)"someValue"));
    }

    static enum Horizontal {
        LEFT,
        RIGHT;

    }
}

