/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util;

import org.apache.isis.applib.util.TitleBuffer;
import org.apache.isis.applib.util.TitleTestObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TitleBufferTest {
    String companyName;
    String name;
    TitleTestObject objectWithEmptyTitle;
    TitleTestObject objectWithNoTitle;
    TitleTestObject objectWithTitle;
    TitleBuffer t1;
    TitleBuffer t2;
    TitleBuffer t3;

    @Before
    public void setUp() {
        this.name = "Fred";
        this.t1 = new TitleBuffer(this.name);
        this.t2 = new TitleBuffer();
        this.companyName = "ABC Co.";
        this.objectWithTitle = new TitleTestObject();
        this.objectWithTitle.setupTitle(this.companyName);
        this.objectWithNoTitle = new TitleTestObject();
        this.objectWithEmptyTitle = new TitleTestObject();
        this.objectWithEmptyTitle.setupTitle("");
        this.t3 = new TitleBuffer("This is a long title");
    }

    @Test
    public void testAppend() {
        this.t1.append("");
        Assert.assertEquals((String)"add empty string", (Object)this.name, (Object)this.t1.toString());
        this.t1.append("Smith");
        this.name = this.name + " Smith";
        Assert.assertEquals((String)"append simple string", (Object)this.name, (Object)this.t1.toString());
        this.t1.append(",", "");
        Assert.assertEquals((String)"append empty string with delimiter", (Object)this.name, (Object)this.t1.toString());
        this.t1.append(",", null);
        Assert.assertEquals((String)"append null with delimiter", (Object)this.name, (Object)this.t1.toString());
        this.t1.append(",", "Xyz Ltd.");
        this.name = this.name + ", Xyz Ltd.";
        Assert.assertEquals((String)"append string with delimiter", (Object)this.name, (Object)this.t1.toString());
    }

    @Test
    public void testAppendEmptyStringLeavesBufferUnchanged() {
        this.t1.append("");
        Assert.assertEquals((Object)this.name, (Object)this.t1.toString());
    }

    @Test
    public void testAppendEmptyStringWithJoinerLeavesBufferUnchanged() {
        this.t1.append(",", "");
        Assert.assertEquals((Object)this.name, (Object)this.t1.toString());
    }

    @Test
    public void testAppendInt() {
        TitleBuffer t = new TitleBuffer();
        t.append(123);
        Assert.assertEquals((Object)"123", (Object)t.toString());
    }

    @Test
    public void testAppendNull() {
        this.t1.append(null);
        Assert.assertEquals((Object)this.name, (Object)this.t1.toString());
    }

    @Test
    public void testAppendNullWithJoinerLeavesBufferUnchanged() {
        this.t1.append(",", null);
        Assert.assertEquals((Object)this.name, (Object)this.t1.toString());
    }

    @Test
    public void testAppendObjectsWithJoinerAddsTitleWithJoinerAndSpace() {
        this.t1.append(",", (Object)this.objectWithTitle);
        Assert.assertEquals((Object)(this.name + ", " + this.companyName), (Object)this.t1.toString());
    }

    @Test
    public void testAppendObjectsWithJoinerOnlyAddsTitleWhenBufferEmpty() {
        this.t2.append(",", (Object)this.objectWithTitle);
        Assert.assertEquals((Object)this.name, (Object)this.t1.toString());
    }

    @Test
    public void testAppendObjectWhereDefaultNotNeeded() {
        this.t1.append((Object)this.objectWithTitle, "none");
        Assert.assertEquals((Object)(this.name + " " + this.companyName), (Object)this.t1.toString());
    }

    @Test
    public void testAppendObjectWhereDefaultUsedAsObjectHasEmptyTitle() {
        this.t1.append((Object)this.objectWithEmptyTitle, "none");
        Assert.assertEquals((Object)(this.name + " none"), (Object)this.t1.toString());
    }

    @Test
    public void testAppendObjectWhereDefaultUsedAsReferenceIsNull() {
        this.t1.append(null, "none");
        Assert.assertEquals((Object)(this.name + " none"), (Object)this.t1.toString());
    }

    @Test
    public void testAppendObjectWithEmptyTitleLeavesBufferUnchanged() {
        this.t1.append((Object)this.objectWithEmptyTitle);
        Assert.assertEquals((Object)this.name, (Object)this.t1.toString());
    }

    @Test
    public void testAppendObjectWithNoTitleLeavesBufferUnchanged() {
        this.t1.append((Object)this.objectWithNoTitle);
        Assert.assertEquals((Object)this.name, (Object)this.t1.toString());
    }

    @Test
    public void testAppendObjectWithTitleAddTitleWithSpace() {
        this.t1.append((Object)this.objectWithTitle);
        Assert.assertEquals((Object)(this.name + " " + this.companyName), (Object)this.t1.toString());
    }

    @Test
    public void testAppendStringAddStringWithSpace() {
        this.t1.append("Smith");
        Assert.assertEquals((Object)"Fred Smith", (Object)this.t1.toString());
    }

    @Test
    public void testAppendStringToEmptyBufferAddsStringWithoutSpace() {
        this.t2.append("Smith");
        Assert.assertEquals((Object)"Smith", (Object)this.t2.toString());
    }

    @Test
    public void testAppendStringWithJoinerAddsStringWithJoinerAndSpace() {
        this.t1.append(",", "Smith");
        Assert.assertEquals((Object)"Fred, Smith", (Object)this.t1.toString());
    }

    @Test
    public void testAppendToBuffer() {
        TitleBuffer t = new TitleBuffer("123");
        t.append("test");
        Assert.assertEquals((Object)"123 test", (Object)t.toString());
    }

    @Test
    public void testAppendToEmpty() {
        TitleBuffer t = new TitleBuffer();
        t.append("test");
        Assert.assertEquals((Object)"test", (Object)t.toString());
    }

    @Test
    public void testAppendValue() {
        TitleTestObject s = new TitleTestObject();
        this.t1.append((Object)s);
        Assert.assertEquals((String)"append empty TextString", (Object)this.name, (Object)this.t1.toString());
        this.t1.append((Object)new TitleTestObject("square"));
        Assert.assertEquals((String)"append empty TextString", (Object)(this.name + " square"), (Object)this.t1.toString());
    }

    @Test
    public void testConcatEmptyStringLeavesBufferUnchanged() {
        this.t1.concat("");
        Assert.assertEquals((Object)this.name, (Object)this.t1.toString());
    }

    @Test
    public void testConcatObjects() {
        this.t1.concat((Object)this.objectWithTitle);
        Assert.assertEquals((Object)(this.name + this.companyName), (Object)this.t1.toString());
    }

    @Test
    public void testConcatObjectsWhereDefaultNotNeededAddsTitle() {
        this.t1.concat((Object)this.objectWithTitle, "none");
        Assert.assertEquals((Object)(this.name + this.companyName), (Object)this.t1.toString());
    }

    @Test
    public void testConcatObjectsWhereNoTitleAddDefaultTitle() {
        this.t1.concat((Object)this.objectWithNoTitle, "none");
        Assert.assertEquals((Object)(this.name + "none"), (Object)this.t1.toString());
    }

    @Test
    public void testConcatObjectWhereNoTitleLeavesBufferUnchanged() {
        this.t1.concat((Object)this.objectWithNoTitle);
        Assert.assertEquals((Object)this.name, (Object)this.t1.toString());
    }

    @Test
    public void testConcatObjectWhereTitleIsAdded() {
        this.t1.concat((Object)this.objectWithTitle);
        Assert.assertEquals((Object)"FredABC Co.", (Object)this.t1.toString());
    }

    @Test
    public void testConcatStringAddsString() {
        this.t1.concat("Smith");
        Assert.assertEquals((Object)"FredSmith", (Object)this.t1.toString());
    }

    @Test
    public void testConstructorsWithObjectWhereDefaultIsNotNeeded() {
        this.t1 = new TitleBuffer((Object)this.objectWithTitle, "test");
        Assert.assertEquals((Object)"ABC Co.", (Object)this.t1.toString());
    }

    @Test
    public void testConstructorsWithObjectWhereDefaultIsUsedAsTitle() {
        this.t1 = new TitleBuffer((Object)this.objectWithNoTitle, "test");
        Assert.assertEquals((Object)"test", (Object)this.t1.toString());
    }

    @Test
    public void testConstructorWithObject() {
        TitleBuffer t = new TitleBuffer((Object)this.objectWithTitle);
        Assert.assertEquals((Object)"ABC Co.", (Object)t.toString());
    }

    @Test
    public void testConstructorWithObjectWithNoTitle() {
        TitleBuffer t = new TitleBuffer((Object)this.objectWithEmptyTitle);
        Assert.assertEquals((Object)"", (Object)t.toString());
    }

    @Test
    public void testConstructorWithString() {
        TitleBuffer t = new TitleBuffer("Test");
        Assert.assertEquals((Object)"Test", (Object)t.toString());
    }

    @Test
    public void testDefaultConstructor() {
        TitleBuffer t = new TitleBuffer();
        Assert.assertEquals((Object)"", (Object)t.toString());
    }

    @Test
    public void testTruncateHasNoEffectUntilTitleLongEnough() {
        this.t3.truncate(5);
        Assert.assertEquals((Object)"This is a long title", (Object)this.t3.toString());
    }

    @Test
    public void testTruncateLimitsTitleLength() {
        this.t3.truncate(3);
        Assert.assertEquals((Object)"This is a...", (Object)this.t3.toString());
    }

    @Test
    public void testTruncateMustBeAUsableLength() {
        try {
            this.t3.truncate(0);
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

