/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util;

import org.apache.isis.applib.util.Reasons;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class ReasonsTest {
    @Test
    public void testNoReasonReturnsNull() throws Exception {
        MatcherAssert.assertThat((Object)Reasons.coalesce((String[])new String[0]), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testSingleNullReturnsNull() throws Exception {
        MatcherAssert.assertThat((Object)Reasons.coalesce((String[])new String[]{null}), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testSingleNonNullReturnsSame() throws Exception {
        MatcherAssert.assertThat((Object)Reasons.coalesce((String[])new String[]{"yada"}), (Matcher)Matchers.is((Object)"yada"));
    }

    @Test
    public void testNullThenNonNullReturnsLatter() throws Exception {
        MatcherAssert.assertThat((Object)Reasons.coalesce((String[])new String[]{null, "yada"}), (Matcher)Matchers.is((Object)"yada"));
    }

    @Test
    public void testNotNullThenNonNullReturnsBothConcatenated() throws Exception {
        MatcherAssert.assertThat((Object)Reasons.coalesce((String[])new String[]{"foobar", "yada"}), (Matcher)Matchers.is((Object)"foobar; yada"));
    }

    @Test
    public void testNotNullThenNullBothFormer() throws Exception {
        MatcherAssert.assertThat((Object)Reasons.coalesce((String[])new String[]{"foobar", null}), (Matcher)Matchers.is((Object)"foobar"));
    }

    @Test
    public void testNullsAreSkippedThenNonNull() throws Exception {
        MatcherAssert.assertThat((Object)Reasons.coalesce((String[])new String[]{"foobar", null, "yada"}), (Matcher)Matchers.is((Object)"foobar; yada"));
    }
}

