/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util;

import org.apache.isis.applib.util.Invoice;
import org.apache.isis.applib.util.Invoice2;
import org.apache.isis.applib.util.InvoiceItem;
import org.apache.isis.applib.util.InvoiceItem2;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;

public class ObjectContractsTest_toString {
    private Invoice inv;
    private Invoice2 inv2;

    @Before
    public void setUp() throws Exception {
        this.inv = new Invoice();
        this.inv2 = new Invoice2();
        this.inv.setNumber("123");
        this.inv2.setNumber("123");
    }

    @Test
    public void vanilla() {
        MatcherAssert.assertThat((Object)InvoiceItem.newInvoiceItem(null, null, null, null).toString(), (Matcher)CoreMatchers.is((Object)"InvoiceItem{invoice=null, productCode=null, quantity=null, rush=null}"));
        MatcherAssert.assertThat((Object)InvoiceItem.newInvoiceItem(this.inv, null, null, null).toString(), (Matcher)CoreMatchers.is((Object)"InvoiceItem{invoice=Invoice{number=123}, productCode=null, quantity=null, rush=null}"));
        MatcherAssert.assertThat((Object)InvoiceItem.newInvoiceItem(this.inv, "A", null, null).toString(), (Matcher)CoreMatchers.is((Object)"InvoiceItem{invoice=Invoice{number=123}, productCode=A, quantity=null, rush=null}"));
        MatcherAssert.assertThat((Object)InvoiceItem.newInvoiceItem(this.inv, "A", 1, null).toString(), (Matcher)CoreMatchers.is((Object)"InvoiceItem{invoice=Invoice{number=123}, productCode=A, quantity=1, rush=null}"));
        MatcherAssert.assertThat((Object)InvoiceItem.newInvoiceItem(this.inv, "A", 1, true).toString(), (Matcher)CoreMatchers.is((Object)"InvoiceItem{invoice=Invoice{number=123}, productCode=A, quantity=1, rush=true}"));
    }

    @Test
    public void customized() {
        MatcherAssert.assertThat((Object)InvoiceItem2.newInvoiceItem(null, null, null, null).toString(), (Matcher)CoreMatchers.is((Object)"InvoiceItem2{invoice=null, productCode=null, quantity=null, rush=null}"));
        MatcherAssert.assertThat((Object)InvoiceItem2.newInvoiceItem(this.inv2, null, null, null).toString(), (Matcher)CoreMatchers.is((Object)"InvoiceItem2{invoice=123, productCode=null, quantity=null, rush=null}"));
        MatcherAssert.assertThat((Object)InvoiceItem2.newInvoiceItem(this.inv2, "A", null, null).toString(), (Matcher)CoreMatchers.is((Object)"InvoiceItem2{invoice=123, productCode=A, quantity=null, rush=null}"));
        MatcherAssert.assertThat((Object)InvoiceItem2.newInvoiceItem(this.inv2, "A", 1, null).toString(), (Matcher)CoreMatchers.is((Object)"InvoiceItem2{invoice=123, productCode=A, quantity=1, rush=null}"));
        MatcherAssert.assertThat((Object)InvoiceItem2.newInvoiceItem(this.inv2, "A", 1, false).toString(), (Matcher)CoreMatchers.is((Object)"InvoiceItem2{invoice=123, productCode=A, quantity=1, rush=false}"));
    }
}

