/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util;

import org.apache.isis.applib.util.ObjectContracts;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ObjectContractsTest_equals {
    private Invoice4 p;
    private Invoice4 q;
    private Invoice4 r;
    private String x;

    @Before
    public void setUp() throws Exception {
        this.p = new Invoice4();
        this.p.setNumber("123");
        this.q = new Invoice4();
        this.q.setNumber("123");
        this.r = new Invoice4();
        this.r.setNumber("456");
        this.x = "this is not an invoice";
    }

    @Test
    public void happyCase() throws Exception {
        Assert.assertTrue((boolean)ObjectContracts.equals((Object)this.p, (Object)this.q, (String)"number"));
    }

    @Test
    public void nullsAreEqual() throws Exception {
        Assert.assertTrue((boolean)ObjectContracts.equals(null, null, (String)"number"));
    }

    @Test
    public void notEqualDifferentValues() throws Exception {
        Assert.assertFalse((boolean)ObjectContracts.equals((Object)this.p, (Object)this.r, (String)"number"));
    }

    @Test
    public void notEqualDifferentTypes() throws Exception {
        Assert.assertFalse((boolean)ObjectContracts.equals((Object)this.p, (Object)this.x, (String)"number"));
    }

    @Test
    public void notEqualNull() throws Exception {
        Assert.assertFalse((boolean)ObjectContracts.equals((Object)this.p, null, (String)"number"));
    }

    static class Invoice4 {
        private static final String KEY_PROPERTIES = "number";
        private String number;

        Invoice4() {
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public int hashCode() {
            return ObjectContracts.hashCode((Object)this, (String)KEY_PROPERTIES);
        }

        public boolean equals(Object obj) {
            return ObjectContracts.equals((Object)this, (Object)obj, (String)KEY_PROPERTIES);
        }
    }
}

