/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util;

import org.apache.isis.applib.util.Enums;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class EnumsTest_converts {
    @Test
    public void converts() {
        this.assertConverts(MyEnum.CONTENT_TYPE, "Content-Type", "contentType");
        this.assertConverts(MyEnum.LAST_MODIFIED, "Last-Modified", "lastModified");
        this.assertConverts(MyEnum.WARNING, "Warning", "warning");
        this.assertConverts(MyEnum.X_REPRESENTATION_TYPE, "X-Representation-Type", "xRepresentationType");
    }

    protected void assertConverts(Enum<?> someEnum, String httpHeader, String camelCase) {
        MatcherAssert.assertThat((Object)Enums.enumToHttpHeader(someEnum), (Matcher)CoreMatchers.is((Object)httpHeader));
        MatcherAssert.assertThat((Object)Enums.enumToCamelCase(someEnum), (Matcher)CoreMatchers.is((Object)camelCase));
    }

    private static enum MyEnum {
        CONTENT_TYPE,
        LAST_MODIFIED,
        WARNING,
        X_REPRESENTATION_TYPE,
        OBJECT_ACTION;

    }
}

