/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.spec;

import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.spec.AbstractSpecification2;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class AbstractSpecification2Test {
    private AbstractSpecification2<String> specAbstractSomeDomainObject;

    @Test
    public void shouldSatisfyByDefaultForNull() {
        this.specAbstractSomeDomainObject = new AbstractSpecification2<String>(){

            public TranslatableString satisfiesTranslatableSafely(String obj) {
                return null;
            }
        };
        MatcherAssert.assertThat((Object)this.specAbstractSomeDomainObject.satisfiesTranslatable(null), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldNotSatisfyForNullIfConfiguredAsSuch() {
        this.specAbstractSomeDomainObject = new AbstractSpecification2<String>(AbstractSpecification2.Nullability.ENSURE_NOT_NULL, AbstractSpecification2.TypeChecking.IGNORE_INCORRECT_TYPE){

            public TranslatableString satisfiesTranslatableSafely(String obj) {
                return null;
            }
        };
        MatcherAssert.assertThat((Object)this.specAbstractSomeDomainObject.satisfiesTranslatable(null), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
    }

    @Test
    public void shouldSatisfyByDefaultForIncorrectType() {
        this.specAbstractSomeDomainObject = new AbstractSpecification2<String>(){

            public TranslatableString satisfiesTranslatableSafely(String obj) {
                return null;
            }
        };
        MatcherAssert.assertThat((Object)this.specAbstractSomeDomainObject.satisfiesTranslatable((Object)1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldNotSatisfyForIncorrectTypeIfConfiguredAsSuch() {
        this.specAbstractSomeDomainObject = new AbstractSpecification2<String>(AbstractSpecification2.Nullability.IGNORE_IF_NULL, AbstractSpecification2.TypeChecking.ENSURE_CORRECT_TYPE){

            public TranslatableString satisfiesTranslatableSafely(String obj) {
                return null;
            }
        };
        MatcherAssert.assertThat((Object)this.specAbstractSomeDomainObject.satisfiesTranslatable((Object)1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
    }

    @Test
    public void shouldSatisfyForNonNullCorrectTypeIfConfiguredAsSuch() {
        this.specAbstractSomeDomainObject = new AbstractSpecification2<String>(AbstractSpecification2.Nullability.ENSURE_NOT_NULL, AbstractSpecification2.TypeChecking.ENSURE_CORRECT_TYPE){

            public TranslatableString satisfiesTranslatableSafely(String obj) {
                return null;
            }
        };
        MatcherAssert.assertThat((Object)this.specAbstractSomeDomainObject.satisfiesTranslatable((Object)new String()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

