/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.wrapper.control;

import org.apache.isis.applib.services.wrapper.control.ExceptionHandler;
import org.apache.isis.applib.services.wrapper.control.ExecutionMode;
import org.apache.isis.applib.services.wrapper.control.SyncControl;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class SyncControl_Test {
    @Test
    public void defaults() throws Exception {
        SyncControl control = SyncControl.control();
        Assertions.assertThat((Iterable)control.getExecutionModes()).isEmpty();
    }

    @Test
    public void check_rules() throws Exception {
        SyncControl control = SyncControl.control();
        control.withCheckRules();
        Assertions.assertThat((Iterable)control.getExecutionModes()).isEmpty();
    }

    @Test
    public void skip_rules() throws Exception {
        SyncControl control = SyncControl.control();
        control.withSkipRules();
        Assertions.assertThat((Iterable)control.getExecutionModes()).contains((Object[])new ExecutionMode[]{ExecutionMode.SKIP_RULE_VALIDATION});
    }

    @Test
    public void execute() throws Exception {
        SyncControl control = SyncControl.control();
        control.withExecute();
        Assertions.assertThat((Iterable)control.getExecutionModes()).isEmpty();
    }

    @Test
    public void no_execute() throws Exception {
        SyncControl control = SyncControl.control();
        control.withNoExecute();
        Assertions.assertThat((Iterable)control.getExecutionModes()).contains((Object[])new ExecutionMode[]{ExecutionMode.SKIP_EXECUTION});
    }

    @Test
    public void chaining() throws Exception {
        ExceptionHandler exceptionHandler = ex -> null;
        SyncControl control = (SyncControl)((SyncControl)SyncControl.control().withNoExecute().withSkipRules()).with(exceptionHandler);
        Assertions.assertThat((Iterable)control.getExecutionModes()).containsExactlyInAnyOrder((Object[])new ExecutionMode[]{ExecutionMode.SKIP_RULE_VALIDATION, ExecutionMode.SKIP_EXECUTION});
    }
}

