/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.wrapper.control;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.isis.applib.services.wrapper.control.AsyncControl;
import org.apache.isis.applib.services.wrapper.control.ExceptionHandler;
import org.apache.isis.applib.services.wrapper.control.ExecutionMode;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.core.task.TaskExecutor;
import org.springframework.core.task.support.ExecutorServiceAdapter;
import org.springframework.core.task.support.TaskExecutorAdapter;

public class AsyncControl_Test {
    @Test
    public void defaults() throws Exception {
        AsyncControl control = AsyncControl.returningVoid();
        Assertions.assertThat((Iterable)control.getExecutionModes()).isEmpty();
    }

    @Test
    public void check_rules() throws Exception {
        AsyncControl control = AsyncControl.returningVoid();
        control.withCheckRules();
        Assertions.assertThat((Iterable)control.getExecutionModes()).isEmpty();
    }

    @Test
    public void skip_rules() throws Exception {
        AsyncControl control = AsyncControl.returningVoid();
        control.withSkipRules();
        Assertions.assertThat((Iterable)control.getExecutionModes()).contains((Object[])new ExecutionMode[]{ExecutionMode.SKIP_RULE_VALIDATION});
    }

    @Test
    public void user() throws Exception {
        AsyncControl control = AsyncControl.returningVoid();
        control.withUser("fred");
        Assertions.assertThat((String)control.getUser()).isEqualTo("fred");
    }

    @Test
    public void roles() throws Exception {
        AsyncControl control = AsyncControl.returningVoid();
        control.withRoles(new String[]{"role-1", "role-2"});
        Assertions.assertThat((List)control.getRoles()).containsExactlyInAnyOrder((Object[])new String[]{"role-1", "role-2"});
    }

    @Test
    public void chaining() throws Exception {
        ExecutorServiceAdapter executorService = new ExecutorServiceAdapter((TaskExecutor)new TaskExecutorAdapter(new Executor(){

            @Override
            public void execute(Runnable command) {
            }
        }));
        ExceptionHandler exceptionHandler = ex -> null;
        AsyncControl control = (AsyncControl)((AsyncControl)AsyncControl.returning(String.class).withSkipRules()).withUser("fred").withRoles(new String[]{"role-1", "role-2"}).with((ExecutorService)executorService).with(exceptionHandler);
        Assertions.assertThat((Iterable)control.getExecutionModes()).containsExactlyInAnyOrder((Object[])new ExecutionMode[]{ExecutionMode.SKIP_RULE_VALIDATION});
        Assertions.assertThat((Object)control.getExecutorService()).isSameAs((Object)executorService);
        Assertions.assertThat(control.getExceptionHandler().orElse(null)).isSameAs((Object)exceptionHandler);
    }
}

