/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.metamodel;

import org.apache.isis.applib.services.metamodel.MetaModelService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class MetaModelService_Config_Test {
    @Test
    public void ignore_noop() throws Exception {
        MetaModelService.Config config = new MetaModelService.Config();
        MatcherAssert.assertThat((Object)config.isIgnoreNoop(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)false)));
        MetaModelService.Config config2 = config.withIgnoreNoop();
        Assert.assertNotSame((Object)config, (Object)config2);
        MatcherAssert.assertThat((Object)config.isIgnoreNoop(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)false)));
        MatcherAssert.assertThat((Object)config2.isIgnoreNoop(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)true)));
    }

    @Test
    public void packages_prefixes() throws Exception {
        MetaModelService.Config config = new MetaModelService.Config();
        MatcherAssert.assertThat((Object)config.getPackagePrefixes(), (Matcher)Matchers.is((Matcher)Matchers.emptyCollectionOf(String.class)));
        MetaModelService.Config config2 = config.withPackagePrefix("org.foo");
        Assert.assertNotSame((Object)config, (Object)config2);
        MatcherAssert.assertThat((Object)config2.getPackagePrefixes().size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        MatcherAssert.assertThat(config2.getPackagePrefixes().iterator().next(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"org.foo")));
        MetaModelService.Config config3 = config2.withPackagePrefix("org.bar");
        Assert.assertNotSame((Object)config, (Object)config3);
        Assert.assertNotSame((Object)config2, (Object)config3);
        MatcherAssert.assertThat((Object)config3.getPackagePrefixes().size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)2)));
        Assert.assertTrue((boolean)config3.getPackagePrefixes().contains("org.foo"));
        Assert.assertTrue((boolean)config3.getPackagePrefixes().contains("org.bar"));
    }
}

