/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.jaxb;

import org.apache.isis.applib.services.jaxb.JaxbService;
import org.apache.isis.commons.internal.resources._Xml;
import org.apache.isis.schema.ixn.v2.ActionInvocationDto;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

class JaxbServiceTest {
    private JaxbService.Simple jaxbServiceSimple;
    private ActionInvocationDto sampleDto;

    JaxbServiceTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.jaxbServiceSimple = new JaxbService.Simple();
        this.sampleDto = this.getSample();
    }

    @AfterEach
    void tearDown() throws Exception {
    }

    @Test
    @Disabled(value="fails because ActionInvocationDto has no @XmlRootElement annoation")
    void roundtrip() {
        String xml = this.jaxbServiceSimple.toXml((Object)this.sampleDto);
        ActionInvocationDto clone = (ActionInvocationDto)this.jaxbServiceSimple.fromXml(ActionInvocationDto.class, xml);
        Assertions.assertEquals((Object)this.sampleDto, (Object)clone);
    }

    @Test
    void clone_usingUtility() {
        ActionInvocationDto dto = this.getSample();
        this.assertDtoEquals(dto, (ActionInvocationDto)_Xml.clone((Object)dto));
    }

    private ActionInvocationDto getSample() {
        ActionInvocationDto dto = new ActionInvocationDto();
        dto.setTitle("hello");
        dto.setUser("world");
        return dto;
    }

    private void assertDtoEquals(ActionInvocationDto a, ActionInvocationDto b) {
        Assertions.assertEquals((Object)a.getTitle(), (Object)b.getTitle());
        Assertions.assertEquals((Object)a.getUser(), (Object)b.getUser());
    }
}

