/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.i18n;

import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jmock.Expectations;
import org.jmock.auto.Mock;
import org.jmock.integration.junit4.JUnitRuleMockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Rule;
import org.junit.Test;

public class TranslatableStringTest {

    public static class Translate
    extends TranslatableStringTest {
        @Rule
        public final JUnitRuleMockery context = new JUnitRuleMockery();
        @Mock
        private TranslationService mockTranslationService;

        @Test
        public void singularForm() throws Exception {
            String simpleText = "text to translate";
            String someContext = "someContext";
            String translation = "the translation";
            TranslatableString ts = TranslatableString.tr((String)"text to translate", (Object[])new Object[0]);
            this.context.checking((ExpectationBuilder)new Expectations(){
                {
                    ((TranslationService)this.oneOf(mockTranslationService)).translate("someContext", "text to translate");
                    this.will(1.returnValue((Object)"the translation"));
                }
            });
            MatcherAssert.assertThat((Object)ts.translate(this.mockTranslationService, "someContext"), (Matcher)CoreMatchers.is((Object)"the translation"));
        }

        @Test
        public void pluralFormOne() throws Exception {
            String singularText = "singular text to translate";
            String pluralText = "plural text to translate";
            String someContext = "someContext";
            String translation = "the translation";
            TranslatableString ts = TranslatableString.trn((String)"singular text to translate", (String)"plural text to translate", (int)1, (Object[])new Object[0]);
            this.context.checking((ExpectationBuilder)new Expectations(){
                {
                    ((TranslationService)this.oneOf(mockTranslationService)).translate("someContext", "singular text to translate", "plural text to translate", 1);
                    this.will(2.returnValue((Object)"the translation"));
                }
            });
            MatcherAssert.assertThat((Object)ts.translate(this.mockTranslationService, "someContext"), (Matcher)CoreMatchers.is((Object)"the translation"));
        }

        @Test
        public void pluralFormTwo() throws Exception {
            String singularText = "singular text to translate";
            String pluralText = "plural text to translate";
            String someContext = "someContext";
            String translation = "the translation";
            int number = 2;
            TranslatableString ts = TranslatableString.trn((String)"singular text to translate", (String)"plural text to translate", (int)2, (Object[])new Object[0]);
            this.context.checking((ExpectationBuilder)new Expectations(){
                {
                    ((TranslationService)this.oneOf(mockTranslationService)).translate("someContext", "singular text to translate", "plural text to translate", 2);
                    this.will(3.returnValue((Object)"the translation"));
                }
            });
            MatcherAssert.assertThat((Object)ts.translate(this.mockTranslationService, "someContext"), (Matcher)CoreMatchers.is((Object)"the translation"));
        }
    }

    public static class Translated
    extends TranslatableStringTest {
        @Test
        public void singularForm() throws Exception {
            TranslatableString ts = TranslatableString.tr((String)"My name is {lastName}, {firstName} {lastName}.", (Object[])new Object[]{"lastName", "Bond", "firstName", "James"});
            MatcherAssert.assertThat((Object)ts.translated("Iche heisse {lastName}, {firstName} {lastName}."), (Matcher)CoreMatchers.is((Object)"Iche heisse Bond, James Bond."));
        }

        @Test
        public void pluralFormOne() throws Exception {
            TranslatableString ts = TranslatableString.trn((String)"My name is {lastName}, {firstName} {lastName}.", (String)"My name is {firstName} {lastName}.", (int)1, (Object[])new Object[]{"lastName", "Bond", "firstName", "James"});
            MatcherAssert.assertThat((Object)ts.translated("Iche heisse {lastName}, {firstName} {lastName}."), (Matcher)CoreMatchers.is((Object)"Iche heisse Bond, James Bond."));
        }
    }

    public static class GetText
    extends TranslatableStringTest {
        @Test
        public void singularForm() throws Exception {
            TranslatableString ts = TranslatableString.tr((String)"No, you can't do that!", (Object[])new Object[0]);
            MatcherAssert.assertThat((Object)ts.getPattern(), (Matcher)CoreMatchers.is((Object)"No, you can't do that!"));
        }

        @Test
        public void pluralFormOne() throws Exception {
            TranslatableString ts = TranslatableString.trn((String)"You can't do that because there is a dependent object", (String)"You can't do that because there are dependent objects", (int)1, (Object[])new Object[0]);
            MatcherAssert.assertThat((Object)ts.getPattern(), (Matcher)CoreMatchers.is((Object)"You can't do that because there is a dependent object"));
        }

        @Test
        public void pluralFormTwo() throws Exception {
            TranslatableString ts = TranslatableString.trn((String)"You can't do that because there is a dependent object", (String)"You can't do that because there are dependent objects", (int)2, (Object[])new Object[0]);
            MatcherAssert.assertThat((Object)ts.getPattern(), (Matcher)CoreMatchers.is((Object)"You can't do that because there are dependent objects"));
        }
    }
}

