/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.exceprecog;

import java.util.Optional;
import java.util.function.Predicate;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizerAbstract;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class ExceptionRecognizerGeneralTest {
    private ExceptionRecognizer ersGeneral;
    private static final Predicate<Throwable> ALWAYS_TRUE = __ -> true;
    private static final Predicate<Throwable> ALWAYS_FALSE = __ -> false;

    @Test
    public void whenRecognized() {
        this.ersGeneral = new ExceptionRecognizerAbstract(ALWAYS_TRUE){};
        MatcherAssert.assertThat((Object)((ExceptionRecognizer.Recognition)this.ersGeneral.recognize((Throwable)new FooException()).get()).getReason(), (Matcher)CoreMatchers.is((Object)"foo"));
    }

    @Test
    public void whenDoesNotRecognize() {
        this.ersGeneral = new ExceptionRecognizerAbstract(ALWAYS_FALSE){};
        MatcherAssert.assertThat((Object)this.ersGeneral.recognize((Throwable)new FooException()), (Matcher)CoreMatchers.is(Optional.empty()));
    }

    @Test
    public void whenRecognizedWithMessageParser() {
        this.ersGeneral = new ExceptionRecognizerAbstract(ALWAYS_TRUE, s -> "pre: " + s){};
        MatcherAssert.assertThat((Object)((ExceptionRecognizer.Recognition)this.ersGeneral.recognize((Throwable)new FooException()).get()).getReason(), (Matcher)CoreMatchers.is((Object)"pre: foo"));
    }

    static class FooException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public FooException() {
            super("foo");
        }
    }
}

