/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.exceprecog;

import java.util.Optional;
import java.util.function.UnaryOperator;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizerForType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class ExceptionRecognizerForTypeTest {
    private ExceptionRecognizer ersForType;
    private UnaryOperator<String> prepend = $ -> "pre: " + $;

    @Test
    public void whenRecognized() {
        this.ersForType = new ExceptionRecognizerForType(FooException.class);
        MatcherAssert.assertThat((Object)((ExceptionRecognizer.Recognition)this.ersForType.recognize((Throwable)new FooException()).get()).getReason(), (Matcher)CoreMatchers.is((Object)"foo"));
    }

    @Test
    public void whenDoesNotRecognize() {
        this.ersForType = new ExceptionRecognizerForType(FooException.class);
        MatcherAssert.assertThat((Object)this.ersForType.recognize((Throwable)new BarException()), (Matcher)CoreMatchers.is(Optional.empty()));
    }

    @Test
    public void whenRecognizedWithMessageParser() {
        this.ersForType = new ExceptionRecognizerForType(FooException.class, this.prepend);
        MatcherAssert.assertThat((Object)((ExceptionRecognizer.Recognition)this.ersForType.recognize((Throwable)new FooException()).get()).getReason(), (Matcher)CoreMatchers.is((Object)"pre: foo"));
    }

    static class BarException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public BarException() {
            super("bar");
        }
    }

    static class FooException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public FooException() {
            super("foo");
        }
    }
}

