/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.eventbus;

import org.apache.isis.applib.events.domain.AbstractDomainEvent;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class AbstractDomainEvent_veto_Test {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    AbstractDomainEvent<?> ev = new AbstractDomainEvent<Object>(){};

    @Test
    public void hidden_phase_and_veto_using_null() throws Exception {
        this.ev.setEventPhase(AbstractDomainEvent.Phase.HIDE);
        this.ev.veto((String)null, new Object[0]);
        Assert.assertTrue((boolean)this.ev.isHidden());
        Assert.assertFalse((boolean)this.ev.isDisabled());
        Assert.assertNull((Object)this.ev.getDisabledReason());
        Assert.assertFalse((boolean)this.ev.isInvalid());
        Assert.assertNull((Object)this.ev.getInvalidityReason());
    }

    @Test
    public void hidden_phase_and_veto_using_non_null_string() throws Exception {
        this.ev.setEventPhase(AbstractDomainEvent.Phase.HIDE);
        this.ev.veto("hidden", new Object[0]);
        Assert.assertTrue((boolean)this.ev.isHidden());
        Assert.assertFalse((boolean)this.ev.isDisabled());
        Assert.assertNull((Object)this.ev.getDisabledReason());
        Assert.assertFalse((boolean)this.ev.isInvalid());
        Assert.assertNull((Object)this.ev.getInvalidityReason());
    }

    @Test
    public void hidden_phase_and_veto_using_translatable() throws Exception {
        this.ev.setEventPhase(AbstractDomainEvent.Phase.HIDE);
        TranslatableString reason = TranslatableString.tr((String)"hidden", (Object[])new Object[0]);
        this.ev.veto(reason);
        Assert.assertTrue((boolean)this.ev.isHidden());
        Assert.assertFalse((boolean)this.ev.isDisabled());
        Assert.assertNull((Object)this.ev.getDisabledReason());
        Assert.assertFalse((boolean)this.ev.isInvalid());
        Assert.assertNull((Object)this.ev.getInvalidityReason());
    }

    @Test
    public void disable_phase_and_attempt_to_veto_with_null() throws Exception {
        AbstractDomainEvent<Object> ev = new AbstractDomainEvent<Object>(){};
        ev.setEventPhase(AbstractDomainEvent.Phase.DISABLE);
        this.expectedException.expect(IllegalArgumentException.class);
        ev.veto((String)null, new Object[0]);
    }

    @Test
    public void disable_phase_and_veto_using_non_null_string() throws Exception {
        this.ev.setEventPhase(AbstractDomainEvent.Phase.DISABLE);
        String reason = "no, you can't do that";
        this.ev.veto("no, you can't do that", new Object[0]);
        Assert.assertFalse((boolean)this.ev.isHidden());
        Assert.assertTrue((boolean)this.ev.isDisabled());
        Assert.assertEquals((Object)"no, you can't do that", (Object)this.ev.getDisabledReason());
        Assert.assertFalse((boolean)this.ev.isInvalid());
        Assert.assertNull((Object)this.ev.getInvalidityReason());
    }

    @Test
    public void disable_phase_and_veto_using_translatable() throws Exception {
        this.ev.setEventPhase(AbstractDomainEvent.Phase.DISABLE);
        TranslatableString reason = TranslatableString.tr((String)"no, you can't do that", (Object[])new Object[0]);
        this.ev.veto(reason);
        Assert.assertFalse((boolean)this.ev.isHidden());
        Assert.assertTrue((boolean)this.ev.isDisabled());
        Assert.assertEquals((Object)reason, (Object)this.ev.getDisabledReasonTranslatable());
        Assert.assertFalse((boolean)this.ev.isInvalid());
        Assert.assertNull((Object)this.ev.getInvalidityReason());
    }

    @Test
    public void validate_phase_and_attempt_to_veto_with_null() throws Exception {
        this.ev.setEventPhase(AbstractDomainEvent.Phase.VALIDATE);
        this.expectedException.expect(IllegalArgumentException.class);
        this.ev.veto((String)null, new Object[0]);
    }

    @Test
    public void validate_phase_and_veto_using_non_null_string() throws Exception {
        this.ev.setEventPhase(AbstractDomainEvent.Phase.VALIDATE);
        String reason = "no, you can't do that";
        this.ev.veto("no, you can't do that", new Object[0]);
        Assert.assertFalse((boolean)this.ev.isHidden());
        Assert.assertFalse((boolean)this.ev.isDisabled());
        Assert.assertNull((Object)this.ev.getDisabledReason());
        Assert.assertTrue((boolean)this.ev.isInvalid());
        Assert.assertEquals((Object)"no, you can't do that", (Object)this.ev.getInvalidityReason());
    }

    @Test
    public void validate_phase_and_veto_using_translatable() throws Exception {
        this.ev.setEventPhase(AbstractDomainEvent.Phase.VALIDATE);
        TranslatableString reason = TranslatableString.tr((String)"no, you can't do that", (Object[])new Object[0]);
        this.ev.veto(reason);
        Assert.assertFalse((boolean)this.ev.isHidden());
        Assert.assertFalse((boolean)this.ev.isDisabled());
        Assert.assertNull((Object)this.ev.getDisabledReason());
        Assert.assertTrue((boolean)this.ev.isInvalid());
        Assert.assertEquals((Object)reason, (Object)this.ev.getInvalidityReasonTranslatable());
    }
}

