/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.bookmark;

import java.util.Optional;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BookmarkTest {
    BookmarkTest() {
    }

    @Test
    void shouldParse_whenExactly2Token() {
        Bookmark bookmark = (Bookmark)Bookmark.parse((String)"a:b").get();
        Assertions.assertEquals((Object)"a", (Object)bookmark.getObjectType());
        Assertions.assertEquals((Object)"b", (Object)bookmark.getIdentifier());
    }

    @Test
    void shouldNotParse_whenNotAtLeast2Token() {
        Assertions.assertEquals(Optional.empty(), (Object)Bookmark.parse(null));
        Assertions.assertEquals(Optional.empty(), (Object)Bookmark.parse((String)""));
        Assertions.assertEquals(Optional.empty(), (Object)Bookmark.parse((String)"a"));
        Assertions.assertEquals(Optional.empty(), (Object)Bookmark.parse((String)"a:"));
        Assertions.assertEquals(Optional.empty(), (Object)Bookmark.parse((String)":"));
        Assertions.assertEquals(Optional.empty(), (Object)Bookmark.parse((String)":b"));
    }

    @Test
    void shouldParse_whenMoreThan2Token() {
        Bookmark bookmark = (Bookmark)Bookmark.parse((String)"a:b:c").get();
        Assertions.assertEquals((Object)"a", (Object)bookmark.getObjectType());
        Assertions.assertEquals((Object)"b:c", (Object)bookmark.getIdentifier());
    }
}

