/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.query;

import org.apache.isis.applib.query.QueryDefault;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class QueryDefaultTest_withStart_or_withCount {
    private QueryDefault<Customer> queryDefault;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.queryDefault = new QueryDefault(Customer.class, "findByLastName", new Object[]{"lastName", "Smith"});
    }

    @Test
    public void defaults() throws Exception {
        MatcherAssert.assertThat((Object)this.queryDefault.getStart(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)this.queryDefault.getCount(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void typicalHappyCase() throws Exception {
        QueryDefault q = this.queryDefault.withStart(10L).withCount(5L);
        MatcherAssert.assertThat((Object)q, (Matcher)CoreMatchers.is(this.queryDefault));
        MatcherAssert.assertThat((Object)q.getStart(), (Matcher)CoreMatchers.is((Object)10L));
        MatcherAssert.assertThat((Object)q.getCount(), (Matcher)CoreMatchers.is((Object)5L));
    }

    @Test
    public void happyCase_startOnly() throws Exception {
        QueryDefault q = this.queryDefault.withStart(10L);
        MatcherAssert.assertThat((Object)q, (Matcher)CoreMatchers.is(this.queryDefault));
        MatcherAssert.assertThat((Object)q.getStart(), (Matcher)CoreMatchers.is((Object)10L));
        MatcherAssert.assertThat((Object)q.getCount(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void happyCase_startZero() throws Exception {
        QueryDefault q = this.queryDefault.withStart(0L);
        MatcherAssert.assertThat((Object)q, (Matcher)CoreMatchers.is(this.queryDefault));
        MatcherAssert.assertThat((Object)q.getStart(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void startNegative() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.queryDefault.withStart(-1L);
    }

    @Test
    public void happyCase_countOnly() throws Exception {
        QueryDefault q = this.queryDefault.withCount(20L);
        MatcherAssert.assertThat((Object)q, (Matcher)CoreMatchers.is(this.queryDefault));
        MatcherAssert.assertThat((Object)q.getStart(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)q.getCount(), (Matcher)CoreMatchers.is((Object)20L));
    }

    @Test
    public void countNegative() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.queryDefault.withCount(-1L);
    }

    @Test
    public void countZero() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.queryDefault.withCount(0L);
    }

    static class Customer {
        Customer() {
        }
    }
}

