/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.layout.grid.bootstrap3;

import org.apache.isis.applib.layout.grid.bootstrap3.BS3Col;
import org.apache.isis.applib.layout.grid.bootstrap3.Size;
import org.apache.isis.applib.layout.grid.bootstrap3.SizeSpan;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;

public class BS3ColTest {
    BS3Col bs3Col;

    @Before
    public void setUp() throws Exception {
        this.bs3Col = new BS3Col();
    }

    @Test
    public void size_and_span() throws Exception {
        this.bs3Col.setSize(Size.MD);
        this.bs3Col.setSpan(4);
        MatcherAssert.assertThat((Object)this.bs3Col.toCssClass(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"col-md-4")));
    }

    @Test
    public void extra_css_class() throws Exception {
        this.bs3Col.setSize(Size.SM);
        this.bs3Col.setSpan(8);
        this.bs3Col.setCssClass("foobar");
        MatcherAssert.assertThat((Object)this.bs3Col.toCssClass(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"col-sm-8 foobar")));
    }

    @Test
    public void with_additional_classes() throws Exception {
        this.bs3Col.setSize(Size.SM);
        this.bs3Col.setSpan(6);
        this.bs3Col.getSizeSpans().add(SizeSpan.with((Size)Size.MD, (int)5));
        this.bs3Col.getSizeSpans().add(SizeSpan.offset((Size)Size.MD, (int)2));
        MatcherAssert.assertThat((Object)this.bs3Col.toCssClass(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"col-sm-6 col-md-5 col-md-offset-2")));
    }
}

