/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.jaxbadapters;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class JaxbXmlAdaptersContractTest<T> {
    public static final String sampleComplexString = "Hello World!?{[()]}\u00a7$%&=\u00b4`*+~#',;.:-_|@\u20ac\u00b5<>^\u00b0\"";
    public static final byte[] sampleAllTheBytes = new byte[256];
    private final T[] sampleValues;
    private final XmlAdapter<String, T> xmlAdapter;

    @SafeVarargs
    protected JaxbXmlAdaptersContractTest(XmlAdapter<String, T> xmlAdapter, T ... sampleValues) {
        for (int i = 0; i <= 255; ++i) {
            JaxbXmlAdaptersContractTest.sampleAllTheBytes[i] = (byte)i;
        }
        this.sampleValues = sampleValues;
        this.xmlAdapter = xmlAdapter;
    }

    @Test
    final void can_roundtrip() throws Exception {
        XmlAdapter<String, T> xmlAdapter = this.xmlAdapter;
        for (T sampleValue : this.sampleValues) {
            String xml = (String)xmlAdapter.marshal(sampleValue);
            Object recovered = xmlAdapter.unmarshal((Object)xml);
            if (sampleValue instanceof byte[]) {
                Assertions.assertArrayEquals((byte[])((byte[])sampleValue), (byte[])((byte[])recovered));
                continue;
            }
            Assertions.assertEquals(sampleValue, (Object)recovered);
        }
        String nullXml = (String)xmlAdapter.marshal(null);
        Object nullRecovered = xmlAdapter.unmarshal((Object)nullXml);
        Assertions.assertNull((Object)nullRecovered);
    }
}

