/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib;

import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.SomeDomainClass;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;

public class IdentifierTests {
    private Identifier identifier;

    @Before
    public void setUp() {
    }

    @Test
    public void canInstantiateClassIdentifier() {
        this.identifier = Identifier.classIdentifier(SomeDomainClass.class);
        MatcherAssert.assertThat((Object)this.identifier, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
    }

    @Test
    public void classIdentifierClassNameIsSet() {
        Class<SomeDomainClass> domainClass = SomeDomainClass.class;
        String domainClassFullyQualifiedName = domainClass.getCanonicalName();
        this.identifier = Identifier.classIdentifier(domainClass);
        MatcherAssert.assertThat((Object)this.identifier.getClassName(), (Matcher)CoreMatchers.is((Object)domainClassFullyQualifiedName));
    }

    @Test
    public void memberParameterNames() {
        Class<SomeDomainClass> domainClass = SomeDomainClass.class;
        this.identifier = Identifier.actionIdentifier(domainClass, (String)"placeOrder", (Class[])new Class[]{Integer.TYPE, String.class});
        MatcherAssert.assertThat((Object)this.identifier.getMemberParameterNames(), (Matcher)CoreMatchers.is(Arrays.asList("int", "java.lang.String")));
    }

    @Test
    public void paramsIdentityString() {
        Class<SomeDomainClass> domainClass = SomeDomainClass.class;
        this.identifier = Identifier.actionIdentifier(domainClass, (String)"placeOrder", (Class[])new Class[]{Integer.TYPE, String.class, BigDecimal.class});
        MatcherAssert.assertThat((Object)this.identifier.toParmsIdentityString(), (Matcher)CoreMatchers.is((Object)"(int,java.lang.String,java.math.BigDecimal)"));
    }
}

