/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.math3.util.FastMath;
import pl.edu.icm.jlargearrays.ComplexDoubleLargeArray;
import pl.edu.icm.jlargearrays.ComplexFloatLargeArray;
import pl.edu.icm.jlargearrays.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.LargeArrayUtils;

public class LargeArrayArithmetics {
    private LargeArrayArithmetics() {
    }

    public static float[] complexSin(float[] a) {
        float[] res = new float[]{(float)(FastMath.sin(a[0]) * FastMath.cosh(a[1])), (float)(FastMath.cos(a[0]) * FastMath.sinh(a[1]))};
        return res;
    }

    public static double[] complexSin(double[] a) {
        double[] res = new double[]{FastMath.sin(a[0]) * FastMath.cosh(a[1]), FastMath.cos(a[0]) * FastMath.sinh(a[1])};
        return res;
    }

    public static float[] complexCos(float[] a) {
        float[] res = new float[]{(float)(FastMath.cos(a[0]) * FastMath.cosh(a[1])), (float)(-FastMath.sin(a[0]) * FastMath.sinh(a[1]))};
        return res;
    }

    public static double[] complexCos(double[] a) {
        double[] res = new double[]{FastMath.cos(a[0]) * FastMath.cosh(a[1]), -FastMath.sin(a[0]) * FastMath.sinh(a[1])};
        return res;
    }

    public static float[] complexTan(float[] a) {
        float[] s = LargeArrayArithmetics.complexSin(a);
        float[] c = LargeArrayArithmetics.complexCos(a);
        return LargeArrayArithmetics.complexDiv(s, c);
    }

    public static double[] complexTan(double[] a) {
        double[] s = LargeArrayArithmetics.complexSin(a);
        double[] c = LargeArrayArithmetics.complexCos(a);
        return LargeArrayArithmetics.complexDiv(s, c);
    }

    public static float[] complexMult(float[] a, float[] b) {
        float[] res = new float[]{a[0] * b[0] - a[1] * b[1], a[1] * b[0] + a[0] * b[1]};
        return res;
    }

    public static double[] complexMult(double[] a, double[] b) {
        double[] res = new double[]{a[0] * b[0] - a[1] * b[1], a[1] * b[0] + a[0] * b[1]};
        return res;
    }

    public static float[] complexDiv(float[] a, float[] b) {
        float r = b[0] * b[0] + b[1] * b[1];
        float[] res = new float[]{(a[0] * b[0] + a[1] * b[1]) / r, (a[1] * b[0] - a[0] * b[1]) / r};
        return res;
    }

    public static double[] complexDiv(double[] a, double[] b) {
        double r = b[0] * b[0] + b[1] * b[1];
        double[] res = new double[]{(a[0] * b[0] + a[1] * b[1]) / r, (a[1] * b[0] - a[0] * b[1]) / r};
        return res;
    }

    public static float[] complexPow(float[] a, double n) {
        float[] res = new float[2];
        double mod = FastMath.pow(FastMath.sqrt(a[0] * a[0] + a[1] * a[1]), n);
        double arg = FastMath.atan2(a[1], a[0]);
        res[0] = (float)(mod * FastMath.cos(n * arg));
        res[1] = (float)(mod * FastMath.sin(n * arg));
        return res;
    }

    public static double[] complexPow(double[] a, double n) {
        double[] res = new double[2];
        double mod = FastMath.pow(FastMath.sqrt(a[0] * a[0] + a[1] * a[1]), n);
        double arg = FastMath.atan2(a[1], a[0]);
        res[0] = mod * FastMath.cos(n * arg);
        res[1] = mod * FastMath.sin(n * arg);
        return res;
    }

    public static float[] complexSqrt(float[] a) {
        float[] res = new float[2];
        double mod = FastMath.sqrt(a[0] * a[0] + a[1] * a[1]);
        res[0] = (float)FastMath.sqrt(((double)a[0] + mod) / 2.0);
        res[1] = (float)((double)FastMath.signum(a[1]) * FastMath.sqrt(((double)(-a[0]) + mod) / 2.0));
        return res;
    }

    public static double[] complexSqrt(double[] a) {
        double[] res = new double[2];
        double mod = FastMath.sqrt(a[0] * a[0] + a[1] * a[1]);
        res[0] = FastMath.sqrt((a[0] + mod) / 2.0);
        res[1] = FastMath.signum(a[1]) * FastMath.sqrt((-a[0] + mod) / 2.0);
        return res;
    }

    public static float complexAbs(float[] a) {
        return (float)FastMath.sqrt(a[0] * a[0] + a[1] * a[1]);
    }

    public static double complexAbs(double[] a) {
        return FastMath.sqrt(a[0] * a[0] + a[1] * a[1]);
    }

    public static float[] complexLog(float[] a) {
        float[] res = new float[2];
        double mod = FastMath.sqrt(a[0] * a[0] + a[1] * a[1]);
        double arg = FastMath.atan2(a[1], a[0]);
        res[0] = (float)FastMath.log(mod);
        res[1] = (float)arg;
        return res;
    }

    public static double[] complexLog(double[] a) {
        double[] res = new double[2];
        double mod = FastMath.sqrt(a[0] * a[0] + a[1] * a[1]);
        double arg = FastMath.atan2(a[1], a[0]);
        res[0] = FastMath.log(mod);
        res[1] = arg;
        return res;
    }

    public static float[] complexLog10(float[] a) {
        float[] res = new float[2];
        double scale = FastMath.log(10.0);
        double mod = FastMath.sqrt(a[0] * a[0] + a[1] * a[1]);
        double arg = FastMath.atan2(a[1], a[0]) / scale;
        res[0] = (float)(FastMath.log(mod) / scale);
        res[1] = (float)arg;
        return res;
    }

    public static double[] complexLog10(double[] a) {
        double[] res = new double[2];
        double scale = FastMath.log(10.0);
        double mod = FastMath.sqrt(a[0] * a[0] + a[1] * a[1]);
        double arg = FastMath.atan2(a[1], a[0]) / scale;
        res[0] = FastMath.log(mod) / scale;
        res[1] = arg;
        return res;
    }

    public static float[] complexExp(float[] a) {
        float[] res = new float[]{(float)(FastMath.exp(a[0]) * FastMath.cos(a[1])), (float)(FastMath.exp(a[0]) * FastMath.sin(a[1]))};
        return res;
    }

    public static double[] complexExp(double[] a) {
        double[] res = new double[]{FastMath.exp(a[0]) * FastMath.cos(a[1]), FastMath.exp(a[0]) * FastMath.sin(a[1])};
        return res;
    }

    public static float[] complexAsin(float[] a) {
        float[] i = new float[]{0.0f, 1.0f};
        float[] mi = new float[]{0.0f, -1.0f};
        float[] res = LargeArrayArithmetics.complexMult(a, a);
        res[0] = 1.0f - res[0];
        res[1] = 1.0f - res[1];
        res = LargeArrayArithmetics.complexLog(res);
        i = LargeArrayArithmetics.complexMult(i, a);
        res[0] = res[0] + i[0];
        res[1] = res[1] + i[1];
        return LargeArrayArithmetics.complexMult(mi, res);
    }

    public static double[] complexAsin(double[] a) {
        double[] i = new double[]{0.0, 1.0};
        double[] mi = new double[]{0.0, -1.0};
        double[] res = LargeArrayArithmetics.complexMult(a, a);
        res[0] = 1.0 - res[0];
        res[1] = 1.0 - res[1];
        res = LargeArrayArithmetics.complexLog(res);
        i = LargeArrayArithmetics.complexMult(i, a);
        res[0] = res[0] + i[0];
        res[1] = res[1] + i[1];
        return LargeArrayArithmetics.complexMult(mi, res);
    }

    public static float[] complexAcos(float[] a) {
        float[] i = new float[]{0.0f, 1.0f};
        float[] mi = new float[]{0.0f, -1.0f};
        float[] res = LargeArrayArithmetics.complexMult(a, a);
        res[0] = 1.0f - res[0];
        res[1] = 1.0f - res[1];
        res = LargeArrayArithmetics.complexMult(i, res);
        res[0] = res[0] + a[0];
        res[1] = res[1] + a[1];
        res = LargeArrayArithmetics.complexLog(res);
        return LargeArrayArithmetics.complexMult(mi, res);
    }

    public static double[] complexAcos(double[] a) {
        double[] i = new double[]{0.0, 1.0};
        double[] mi = new double[]{0.0, -1.0};
        double[] res = LargeArrayArithmetics.complexMult(a, a);
        res[0] = 1.0 - res[0];
        res[1] = 1.0 - res[1];
        res = LargeArrayArithmetics.complexMult(i, res);
        res[0] = res[0] + a[0];
        res[1] = res[1] + a[1];
        res = LargeArrayArithmetics.complexLog(res);
        return LargeArrayArithmetics.complexMult(mi, res);
    }

    public static float[] complexAtan(float[] a) {
        float[] res = new float[2];
        float[] tmp = new float[2];
        float[] i = new float[]{0.0f, 1.0f};
        res[0] = i[0] + a[0];
        res[1] = i[1] + a[1];
        tmp[0] = i[0] - a[0];
        tmp[1] = i[1] - a[1];
        res = LargeArrayArithmetics.complexLog(LargeArrayArithmetics.complexDiv(res, tmp));
        i[1] = (float)((double)i[1] / 2.0);
        return LargeArrayArithmetics.complexMult(i, res);
    }

    public static double[] complexAtan(double[] a) {
        double[] res = new double[2];
        double[] tmp = new double[2];
        double[] i = new double[]{0.0, 1.0};
        res[0] = i[0] + a[0];
        res[1] = i[1] + a[1];
        tmp[0] = i[0] - a[0];
        tmp[1] = i[1] - a[1];
        res = LargeArrayArithmetics.complexLog(LargeArrayArithmetics.complexDiv(res, tmp));
        i[1] = i[1] / 2.0;
        return LargeArrayArithmetics.complexMult(i, res);
    }

    public static LargeArray add(LargeArray a, LargeArray b) {
        LargeArrayType out_type = a.getType().compareTo(b.getType()) >= 0 ? a.getType() : b.getType();
        return LargeArrayArithmetics.add(a, b, out_type);
    }

    public static LargeArray add(final LargeArray a, final LargeArray b, LargeArrayType out_type) {
        LargeArray res;
        if (a == null || b == null || a.length() != b.length() || !a.isNumeric() || !b.isNumeric()) {
            throw new IllegalArgumentException("a == null || b == null || a.length() != b.length() || !a.isNumeric() || !b.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a.length();
        if (a.isConstant() && b.isConstant()) {
            if (out_type.isIntegerNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, a.getLong(0L) + b.getLong(0L));
            }
            if (out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, a.getDouble(0L) + b.getDouble(0L));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a).getComplexFloat(0L);
                float[] elem_b = ((ComplexFloatLargeArray)b).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, new float[]{elem_a[0] + elem_b[0], elem_a[1] + elem_b[1]});
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a).getComplexDouble(0L);
                double[] elem_b = ((ComplexDoubleLargeArray)b).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, new double[]{elem_a[0] + elem_b[0], elem_a[1] + elem_b[1]});
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType()) {
            res = LargeArrayUtils.create(out_type, length, false);
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    res.setLong(i, a.getLong(i) + b.getLong(i));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                res.setLong(k, a.getLong(k) + b.getLong(k));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        res.setLong(i, a.getLong(i) + b.getLong(i));
                    }
                }
            }
        } else if (out_type.isRealNumericType()) {
            res = LargeArrayUtils.create(out_type, length, false);
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    res.setDouble(i, a.getDouble(i) + b.getDouble(i));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                res.setDouble(k, a.getDouble(k) + b.getDouble(k));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        res.setDouble(i, a.getDouble(i) + b.getDouble(i));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)LargeArrayUtils.convert(a, out_type);
            final ComplexFloatLargeArray _bc = (ComplexFloatLargeArray)LargeArrayUtils.convert(b, out_type);
            res = _ac.getType() == a.getType() && _bc.getType() == b.getType() ? LargeArrayUtils.create(out_type, length, false) : (_ac.getType() != a.getType() ? _ac : _bc);
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                float[] elem_res = new float[2];
                for (long i = 0L; i < length; ++i) {
                    float[] elem_a = _ac.getComplexFloat(i);
                    float[] elem_b = _bc.getComplexFloat(i);
                    elem_res[0] = elem_a[0] + elem_b[0];
                    elem_res[1] = elem_a[1] + elem_b[1];
                    resc.setComplexFloat(i, elem_res);
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] elem_res = new float[2];
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                float[] elem_a = _ac.getComplexFloat(k);
                                float[] elem_b = _bc.getComplexFloat(k);
                                elem_res[0] = elem_a[0] + elem_b[0];
                                elem_res[1] = elem_a[1] + elem_b[1];
                                resc.setComplexFloat(k, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    float[] elem_res = new float[2];
                    for (long i = 0L; i < length; ++i) {
                        float[] elem_a = _ac.getComplexFloat(i);
                        float[] elem_b = _bc.getComplexFloat(i);
                        elem_res[0] = elem_a[0] + elem_b[0];
                        elem_res[1] = elem_a[1] + elem_b[1];
                        resc.setComplexFloat(i, elem_res);
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)LargeArrayUtils.convert(a, out_type);
            final ComplexDoubleLargeArray _bc = (ComplexDoubleLargeArray)LargeArrayUtils.convert(b, out_type);
            res = _ac.getType() == a.getType() && _bc.getType() == b.getType() ? LargeArrayUtils.create(out_type, length, false) : (_ac.getType() != a.getType() ? _ac : _bc);
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                double[] elem_res = new double[2];
                for (long i = 0L; i < length; ++i) {
                    double[] elem_a = _ac.getComplexDouble(i);
                    double[] elem_b = _bc.getComplexDouble(i);
                    elem_res[0] = elem_a[0] + elem_b[0];
                    elem_res[1] = elem_a[1] + elem_b[1];
                    resc.setComplexDouble(i, elem_res);
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] elem_res = new double[2];
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                double[] elem_a = _ac.getComplexDouble(k);
                                double[] elem_b = _bc.getComplexDouble(k);
                                elem_res[0] = elem_a[0] + elem_b[0];
                                elem_res[1] = elem_a[1] + elem_b[1];
                                resc.setComplexDouble(k, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    double[] elem_res = new double[2];
                    for (long i = 0L; i < length; ++i) {
                        double[] elem_a = _ac.getComplexDouble(i);
                        double[] elem_b = _bc.getComplexDouble(i);
                        elem_res[0] = elem_a[0] + elem_b[0];
                        elem_res[1] = elem_a[1] + elem_b[1];
                        resc.setComplexDouble(i, elem_res);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray diff(LargeArray a, LargeArray b) {
        LargeArrayType out_type = a.getType().compareTo(b.getType()) >= 0 ? a.getType() : b.getType();
        return LargeArrayArithmetics.diff(a, b, out_type);
    }

    public static LargeArray diff(final LargeArray a, final LargeArray b, LargeArrayType out_type) {
        LargeArray res;
        if (a == null || b == null || a.length() != b.length() || !a.isNumeric() || !b.isNumeric()) {
            throw new IllegalArgumentException("a == null || b == null || a.length() != b.length() || !a.isNumeric() || !b.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a.length();
        if (a.isConstant() && b.isConstant()) {
            if (out_type.isIntegerNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, a.getLong(0L) - b.getLong(0L));
            }
            if (out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, a.getDouble(0L) - b.getDouble(0L));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a).getComplexFloat(0L);
                float[] elem_b = ((ComplexFloatLargeArray)b).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, new float[]{elem_a[0] - elem_b[0], elem_a[1] - elem_b[1]});
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a).getComplexDouble(0L);
                double[] elem_b = ((ComplexDoubleLargeArray)b).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, new double[]{elem_a[0] - elem_b[0], elem_a[1] - elem_b[1]});
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType()) {
            res = LargeArrayUtils.create(out_type, length, false);
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    res.setLong(i, a.getLong(i) - b.getLong(i));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                res.setLong(k, a.getLong(k) - b.getLong(k));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        res.setLong(i, a.getLong(i) - b.getLong(i));
                    }
                }
            }
        } else if (out_type.isRealNumericType()) {
            res = LargeArrayUtils.create(out_type, length, false);
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    res.setDouble(i, a.getDouble(i) - b.getDouble(i));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                res.setDouble(k, a.getDouble(k) - b.getDouble(k));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        res.setDouble(i, a.getDouble(i) - b.getDouble(i));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)LargeArrayUtils.convert(a, out_type);
            final ComplexFloatLargeArray _bc = (ComplexFloatLargeArray)LargeArrayUtils.convert(b, out_type);
            res = _ac.getType() == a.getType() && _bc.getType() == b.getType() ? LargeArrayUtils.create(out_type, length, false) : (_ac.getType() != a.getType() ? _ac : _bc);
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                float[] elem_res = new float[2];
                for (long i = 0L; i < length; ++i) {
                    float[] elem_a = _ac.getComplexFloat(i);
                    float[] elem_b = _bc.getComplexFloat(i);
                    elem_res[0] = elem_a[0] - elem_b[0];
                    elem_res[1] = elem_a[1] - elem_b[1];
                    resc.setComplexFloat(i, elem_res);
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] elem_res = new float[2];
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                float[] elem_a = _ac.getComplexFloat(k);
                                float[] elem_b = _bc.getComplexFloat(k);
                                elem_res[0] = elem_a[0] - elem_b[0];
                                elem_res[1] = elem_a[1] - elem_b[1];
                                resc.setComplexFloat(k, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    float[] elem_res = new float[2];
                    for (long i = 0L; i < length; ++i) {
                        float[] elem_a = _ac.getComplexFloat(i);
                        float[] elem_b = _bc.getComplexFloat(i);
                        elem_res[0] = elem_a[0] - elem_b[0];
                        elem_res[1] = elem_a[1] - elem_b[1];
                        resc.setComplexFloat(i, elem_res);
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)LargeArrayUtils.convert(a, out_type);
            final ComplexDoubleLargeArray _bc = (ComplexDoubleLargeArray)LargeArrayUtils.convert(b, out_type);
            res = _ac.getType() == a.getType() && _bc.getType() == b.getType() ? LargeArrayUtils.create(out_type, length, false) : (_ac.getType() != a.getType() ? _ac : _bc);
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                double[] elem_res = new double[2];
                for (long i = 0L; i < length; ++i) {
                    double[] elem_a = _ac.getComplexDouble(i);
                    double[] elem_b = _bc.getComplexDouble(i);
                    elem_res[0] = elem_a[0] - elem_b[0];
                    elem_res[1] = elem_a[1] - elem_b[1];
                    resc.setComplexDouble(i, elem_res);
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] elem_res = new double[2];
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                double[] elem_a = _ac.getComplexDouble(k);
                                double[] elem_b = _bc.getComplexDouble(k);
                                elem_res[0] = elem_a[0] - elem_b[0];
                                elem_res[1] = elem_a[1] - elem_b[1];
                                resc.setComplexDouble(k, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    double[] elem_res = new double[2];
                    for (long i = 0L; i < length; ++i) {
                        double[] elem_a = _ac.getComplexDouble(i);
                        double[] elem_b = _bc.getComplexDouble(i);
                        elem_res[0] = elem_a[0] - elem_b[0];
                        elem_res[1] = elem_a[1] - elem_b[1];
                        resc.setComplexDouble(i, elem_res);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray mult(LargeArray a, LargeArray b) {
        LargeArrayType out_type = a.getType().compareTo(b.getType()) >= 0 ? a.getType() : b.getType();
        return LargeArrayArithmetics.mult(a, b, out_type);
    }

    public static LargeArray mult(final LargeArray a, final LargeArray b, LargeArrayType out_type) {
        LargeArray res;
        if (a == null || b == null || a.length() != b.length() || !a.isNumeric() || !b.isNumeric()) {
            throw new IllegalArgumentException("a == null || b == null || a.length() != b.length() || !a.isNumeric() || !b.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a.length();
        if (a.isConstant() && b.isConstant()) {
            if (out_type.isIntegerNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, a.getLong(0L) * b.getLong(0L));
            }
            if (out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, a.getDouble(0L) * b.getDouble(0L));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a).getComplexFloat(0L);
                float[] elem_b = ((ComplexFloatLargeArray)b).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexMult(elem_a, elem_b));
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a).getComplexDouble(0L);
                double[] elem_b = ((ComplexDoubleLargeArray)b).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexMult(elem_a, elem_b));
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType()) {
            res = LargeArrayUtils.create(out_type, length, false);
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    res.setLong(i, a.getLong(i) * b.getLong(i));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                res.setLong(k, a.getLong(k) * b.getLong(k));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        res.setLong(i, a.getLong(i) * b.getLong(i));
                    }
                }
            }
        } else if (out_type.isRealNumericType()) {
            res = LargeArrayUtils.create(out_type, length, false);
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    res.setDouble(i, a.getDouble(i) * b.getDouble(i));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                res.setDouble(k, a.getDouble(k) * b.getDouble(k));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        res.setDouble(i, a.getDouble(i) * b.getDouble(i));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)LargeArrayUtils.convert(a, out_type);
            final ComplexFloatLargeArray _bc = (ComplexFloatLargeArray)LargeArrayUtils.convert(b, out_type);
            res = _ac.getType() == a.getType() && _bc.getType() == b.getType() ? LargeArrayUtils.create(out_type, length, false) : (_ac.getType() != a.getType() ? _ac : _bc);
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                float[] elem_res = new float[2];
                for (long i = 0L; i < length; ++i) {
                    float[] elem_a = _ac.getComplexFloat(i);
                    float[] elem_b = _bc.getComplexFloat(i);
                    elem_res[0] = elem_a[0] * elem_b[0] - elem_a[1] * elem_b[1];
                    elem_res[1] = elem_a[1] * elem_b[0] + elem_a[0] * elem_b[1];
                    resc.setComplexFloat(i, elem_res);
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] elem_res = new float[2];
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                float[] elem_a = _ac.getComplexFloat(k);
                                float[] elem_b = _bc.getComplexFloat(k);
                                elem_res[0] = elem_a[0] * elem_b[0] - elem_a[1] * elem_b[1];
                                elem_res[1] = elem_a[1] * elem_b[0] + elem_a[0] * elem_b[1];
                                resc.setComplexFloat(k, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    float[] elem_res = new float[2];
                    for (long i = 0L; i < length; ++i) {
                        float[] elem_a = _ac.getComplexFloat(i);
                        float[] elem_b = _bc.getComplexFloat(i);
                        elem_res[0] = elem_a[0] * elem_b[0] - elem_a[1] * elem_b[1];
                        elem_res[1] = elem_a[1] * elem_b[0] + elem_a[0] * elem_b[1];
                        resc.setComplexFloat(i, elem_res);
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)LargeArrayUtils.convert(a, out_type);
            final ComplexDoubleLargeArray _bc = (ComplexDoubleLargeArray)LargeArrayUtils.convert(b, out_type);
            res = _ac.getType() == a.getType() && _bc.getType() == b.getType() ? LargeArrayUtils.create(out_type, length, false) : (_ac.getType() != a.getType() ? _ac : _bc);
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                double[] elem_res = new double[2];
                for (long i = 0L; i < length; ++i) {
                    double[] elem_a = _ac.getComplexDouble(i);
                    double[] elem_b = _bc.getComplexDouble(i);
                    elem_res[0] = elem_a[0] * elem_b[0] - elem_a[1] * elem_b[1];
                    elem_res[1] = elem_a[1] * elem_b[0] + elem_a[0] * elem_b[1];
                    resc.setComplexDouble(i, elem_res);
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] elem_res = new double[2];
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                double[] elem_a = _ac.getComplexDouble(k);
                                double[] elem_b = _bc.getComplexDouble(k);
                                elem_res[0] = elem_a[0] * elem_b[0] - elem_a[1] * elem_b[1];
                                elem_res[1] = elem_a[1] * elem_b[0] + elem_a[0] * elem_b[1];
                                resc.setComplexDouble(k, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    double[] elem_res = new double[2];
                    for (long i = 0L; i < length; ++i) {
                        double[] elem_a = _ac.getComplexDouble(i);
                        double[] elem_b = _bc.getComplexDouble(i);
                        elem_res[0] = elem_a[0] * elem_b[0] - elem_a[1] * elem_b[1];
                        elem_res[1] = elem_a[1] * elem_b[0] + elem_a[0] * elem_b[1];
                        resc.setComplexDouble(i, elem_res);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray div(LargeArray a, LargeArray b) {
        LargeArrayType out_type = a.getType().compareTo(b.getType()) >= 0 ? a.getType() : b.getType();
        return LargeArrayArithmetics.div(a, b, out_type);
    }

    public static LargeArray div(final LargeArray a, final LargeArray b, LargeArrayType out_type) {
        LargeArray res;
        if (a == null || b == null || a.length() != b.length() || !a.isNumeric() || !b.isNumeric()) {
            throw new IllegalArgumentException("a == null || b == null || a.length() != b.length() || !a.isNumeric() || !b.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a.length();
        if (a.isConstant() && b.isConstant()) {
            if (out_type.isIntegerNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, a.getLong(0L) / b.getLong(0L));
            }
            if (out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, a.getDouble(0L) / b.getDouble(0L));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a).getComplexFloat(0L);
                float[] elem_b = ((ComplexFloatLargeArray)b).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexDiv(elem_a, elem_b));
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a).getComplexDouble(0L);
                double[] elem_b = ((ComplexDoubleLargeArray)b).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexDiv(elem_a, elem_b));
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType()) {
            res = LargeArrayUtils.create(out_type, length, false);
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    res.setLong(i, a.getLong(i) / b.getLong(i));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                res.setLong(k, a.getLong(k) / b.getLong(k));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        res.setLong(i, a.getLong(i) / b.getLong(i));
                    }
                }
            }
        } else if (out_type.isRealNumericType()) {
            res = LargeArrayUtils.create(out_type, length, false);
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    res.setDouble(i, a.getDouble(i) / b.getDouble(i));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                res.setDouble(k, a.getDouble(k) / b.getDouble(k));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        res.setDouble(i, a.getDouble(i) / b.getDouble(i));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)LargeArrayUtils.convert(a, out_type);
            final ComplexFloatLargeArray _bc = (ComplexFloatLargeArray)LargeArrayUtils.convert(b, out_type);
            res = _ac.getType() == a.getType() && _bc.getType() == b.getType() ? LargeArrayUtils.create(out_type, length, false) : (_ac.getType() != a.getType() ? _ac : _bc);
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                float[] elem_res = new float[2];
                for (long i = 0L; i < length; ++i) {
                    float[] elem_a = _ac.getComplexFloat(i);
                    float[] elem_b = _bc.getComplexFloat(i);
                    float r = elem_b[0] * elem_b[0] + elem_b[1] * elem_b[1];
                    elem_res[0] = (elem_a[0] * elem_b[0] + elem_a[1] * elem_b[1]) / r;
                    elem_res[1] = (elem_a[1] * elem_b[0] - elem_a[0] * elem_b[1]) / r;
                    resc.setComplexFloat(i, elem_res);
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] elem_res = new float[2];
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                float[] elem_a = _ac.getComplexFloat(k);
                                float[] elem_b = _bc.getComplexFloat(k);
                                float r = elem_b[0] * elem_b[0] + elem_b[1] * elem_b[1];
                                elem_res[0] = (elem_a[0] * elem_b[0] + elem_a[1] * elem_b[1]) / r;
                                elem_res[1] = (elem_a[1] * elem_b[0] - elem_a[0] * elem_b[1]) / r;
                                resc.setComplexFloat(k, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    float[] elem_res = new float[2];
                    for (long i = 0L; i < length; ++i) {
                        float[] elem_a = _ac.getComplexFloat(i);
                        float[] elem_b = _bc.getComplexFloat(i);
                        float r = elem_b[0] * elem_b[0] + elem_b[1] * elem_b[1];
                        elem_res[0] = (elem_a[0] * elem_b[0] + elem_a[1] * elem_b[1]) / r;
                        elem_res[1] = (elem_a[1] * elem_b[0] - elem_a[0] * elem_b[1]) / r;
                        resc.setComplexFloat(i, elem_res);
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)LargeArrayUtils.convert(a, out_type);
            final ComplexDoubleLargeArray _bc = (ComplexDoubleLargeArray)LargeArrayUtils.convert(b, out_type);
            res = _ac.getType() == a.getType() && _bc.getType() == b.getType() ? LargeArrayUtils.create(out_type, length, false) : (_ac.getType() != a.getType() ? _ac : _bc);
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                double[] elem_res = new double[2];
                for (long i = 0L; i < length; ++i) {
                    double[] elem_a = _ac.getComplexDouble(i);
                    double[] elem_b = _bc.getComplexDouble(i);
                    double r = elem_b[0] * elem_b[0] + elem_b[1] * elem_b[1];
                    elem_res[0] = (elem_a[0] * elem_b[0] + elem_a[1] * elem_b[1]) / r;
                    elem_res[1] = (elem_a[1] * elem_b[0] - elem_a[0] * elem_b[1]) / r;
                    resc.setComplexDouble(i, elem_res);
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] elem_res = new double[2];
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                double[] elem_a = _ac.getComplexDouble(k);
                                double[] elem_b = _bc.getComplexDouble(k);
                                double r = elem_b[0] * elem_b[0] + elem_b[1] * elem_b[1];
                                elem_res[0] = (elem_a[0] * elem_b[0] + elem_a[1] * elem_b[1]) / r;
                                elem_res[1] = (elem_a[1] * elem_b[0] - elem_a[0] * elem_b[1]) / r;
                                resc.setComplexDouble(k, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    double[] elem_res = new double[2];
                    for (long i = 0L; i < length; ++i) {
                        double[] elem_a = _ac.getComplexDouble(i);
                        double[] elem_b = _bc.getComplexDouble(i);
                        double r = elem_b[0] * elem_b[0] + elem_b[1] * elem_b[1];
                        elem_res[0] = (elem_a[0] * elem_b[0] + elem_a[1] * elem_b[1]) / r;
                        elem_res[1] = (elem_a[1] * elem_b[0] - elem_a[0] * elem_b[1]) / r;
                        resc.setComplexDouble(i, elem_res);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray pow(LargeArray a, double n) {
        LargeArrayType out_type = a.getType().isIntegerNumericType() ? LargeArrayType.FLOAT : a.getType();
        return LargeArrayArithmetics.pow(a, n, out_type);
    }

    public static LargeArray pow(final LargeArray a, final double n, LargeArrayType out_type) {
        if (a == null || !a.isNumeric()) {
            throw new IllegalArgumentException("a == null || !a.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a.length();
        if (a.isConstant()) {
            if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, FastMath.pow(a.getDouble(0L), n));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexPow(elem_a, n));
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexPow(elem_a, n));
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        final LargeArray res = LargeArrayUtils.create(out_type, length, false);
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    res.setDouble(i, FastMath.pow(a.getDouble(i), n));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                res.setDouble(k, FastMath.pow(a.getDouble(k), n));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        res.setDouble(i, FastMath.pow(a.getDouble(i), n));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)a;
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                float[] elem_res = new float[2];
                for (long i = 0L; i < length; ++i) {
                    float[] elem_a = _ac.getComplexFloat(i);
                    double mod = FastMath.pow(FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]), n);
                    double arg = FastMath.atan2(elem_a[1], elem_a[0]);
                    elem_res[0] = (float)(mod * FastMath.cos(n * arg));
                    elem_res[1] = (float)(mod * FastMath.sin(n * arg));
                    resc.setComplexFloat(i, elem_res);
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] elem_res = new float[2];
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                float[] elem_a = _ac.getComplexFloat(k);
                                double mod = FastMath.pow(FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]), n);
                                double arg = FastMath.atan2(elem_a[1], elem_a[0]);
                                elem_res[0] = (float)(mod * FastMath.cos(n * arg));
                                elem_res[1] = (float)(mod * FastMath.sin(n * arg));
                                resc.setComplexFloat(k, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    float[] elem_res = new float[2];
                    for (long i = 0L; i < length; ++i) {
                        float[] elem_a = _ac.getComplexFloat(i);
                        double mod = FastMath.pow(FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]), n);
                        double arg = FastMath.atan2(elem_a[1], elem_a[0]);
                        elem_res[0] = (float)(mod * FastMath.cos(n * arg));
                        elem_res[1] = (float)(mod * FastMath.sin(n * arg));
                        resc.setComplexFloat(i, elem_res);
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)a;
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                double[] elem_res = new double[2];
                for (long i = 0L; i < length; ++i) {
                    double[] elem_a = _ac.getComplexDouble(i);
                    double mod = FastMath.pow(FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]), n);
                    double arg = FastMath.atan2(elem_a[1], elem_a[0]);
                    elem_res[0] = mod * FastMath.cos(n * arg);
                    elem_res[1] = mod * FastMath.sin(n * arg);
                    resc.setComplexDouble(i, elem_res);
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] elem_res = new double[2];
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                double[] elem_a = _ac.getComplexDouble(k);
                                double mod = FastMath.pow(FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]), n);
                                double arg = FastMath.atan2(elem_a[1], elem_a[0]);
                                elem_res[0] = mod * FastMath.cos(n * arg);
                                elem_res[1] = mod * FastMath.sin(n * arg);
                                resc.setComplexDouble(k, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    double[] elem_res = new double[2];
                    for (long i = 0L; i < length; ++i) {
                        double[] elem_a = _ac.getComplexDouble(i);
                        double mod = FastMath.pow(FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]), n);
                        double arg = FastMath.atan2(elem_a[1], elem_a[0]);
                        elem_res[0] = mod * FastMath.cos(n * arg);
                        elem_res[1] = mod * FastMath.sin(n * arg);
                        resc.setComplexDouble(i, elem_res);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray neg(LargeArray a) {
        LargeArrayType out_type = a.getType();
        return LargeArrayArithmetics.neg(a, out_type);
    }

    public static LargeArray neg(final LargeArray a, LargeArrayType out_type) {
        if (a == null || !a.isNumeric()) {
            throw new IllegalArgumentException("a == null || !a.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a.length();
        if (a.isConstant()) {
            if (out_type.isIntegerNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, -a.getLong(0L));
            }
            if (out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, -a.getDouble(0L));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, new float[]{-elem_a[0], -elem_a[1]});
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, new double[]{-elem_a[0], -elem_a[1]});
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        final LargeArray res = LargeArrayUtils.create(out_type, length, false);
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    res.setLong(i, -a.getLong(i));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                res.setLong(k, -a.getLong(k));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        res.setLong(i, -a.getLong(i));
                    }
                }
            }
        } else if (out_type.isRealNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    res.setDouble(i, -a.getDouble(i));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                res.setDouble(k, -a.getDouble(k));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        res.setDouble(i, -a.getDouble(i));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)a;
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                float[] elem_res = new float[2];
                for (long i = 0L; i < length; ++i) {
                    float[] elem_a = _ac.getComplexFloat(i);
                    elem_res[0] = -elem_a[0];
                    elem_res[1] = -elem_a[1];
                    resc.setComplexFloat(i, elem_res);
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] elem_res = new float[2];
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                float[] elem_a = _ac.getComplexFloat(k);
                                elem_res[0] = -elem_a[0];
                                elem_res[1] = -elem_a[1];
                                resc.setComplexFloat(k, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    float[] elem_res = new float[2];
                    for (long i = 0L; i < length; ++i) {
                        float[] elem_a = _ac.getComplexFloat(i);
                        elem_res[0] = -elem_a[0];
                        elem_res[1] = -elem_a[1];
                        resc.setComplexFloat(i, elem_res);
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)a;
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                double[] elem_res = new double[2];
                for (long i = 0L; i < length; ++i) {
                    double[] elem_a = _ac.getComplexDouble(i);
                    elem_res[0] = -elem_a[0];
                    elem_res[1] = -elem_a[1];
                    resc.setComplexDouble(i, elem_res);
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] elem_res = new double[2];
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                double[] elem_a = _ac.getComplexDouble(k);
                                elem_res[0] = -elem_a[0];
                                elem_res[1] = -elem_a[1];
                                resc.setComplexDouble(k, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    double[] elem_res = new double[2];
                    for (long i = 0L; i < length; ++i) {
                        double[] elem_a = _ac.getComplexDouble(i);
                        elem_res[0] = -elem_a[0];
                        elem_res[1] = -elem_a[1];
                        resc.setComplexDouble(i, elem_res);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray sqrt(LargeArray a) {
        LargeArrayType out_type = a.getType().isIntegerNumericType() ? LargeArrayType.FLOAT : a.getType();
        return LargeArrayArithmetics.sqrt(a, out_type);
    }

    public static LargeArray sqrt(final LargeArray a, LargeArrayType out_type) {
        if (a == null || !a.isNumeric()) {
            throw new IllegalArgumentException("a == null || !a.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a.length();
        if (a.isConstant()) {
            if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, FastMath.sqrt(a.getDouble(0L)));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexSqrt(elem_a));
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexSqrt(elem_a));
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        final LargeArray res = LargeArrayUtils.create(out_type, length, false);
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    res.setDouble(i, FastMath.sqrt(a.getDouble(i)));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                res.setDouble(k, FastMath.sqrt(a.getDouble(k)));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        res.setDouble(i, FastMath.sqrt(a.getDouble(i)));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)a;
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                float[] elem_res = new float[2];
                for (long i = 0L; i < length; ++i) {
                    float[] elem_a = _ac.getComplexFloat(i);
                    double mod = FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]);
                    elem_res[0] = (float)FastMath.sqrt(((double)elem_a[0] + mod) / 2.0);
                    elem_res[1] = (float)((double)FastMath.signum(elem_a[1]) * FastMath.sqrt(((double)(-elem_a[0]) + mod) / 2.0));
                    resc.setComplexFloat(i, elem_res);
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] elem_res = new float[2];
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                float[] elem_a = _ac.getComplexFloat(k);
                                double mod = FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]);
                                elem_res[0] = (float)FastMath.sqrt(((double)elem_a[0] + mod) / 2.0);
                                elem_res[1] = (float)((double)FastMath.signum(elem_a[1]) * FastMath.sqrt(((double)(-elem_a[0]) + mod) / 2.0));
                                resc.setComplexFloat(k, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    float[] elem_res = new float[2];
                    for (long i = 0L; i < length; ++i) {
                        float[] elem_a = _ac.getComplexFloat(i);
                        double mod = FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]);
                        elem_res[0] = (float)FastMath.sqrt(((double)elem_a[0] + mod) / 2.0);
                        elem_res[1] = (float)((double)FastMath.signum(elem_a[1]) * FastMath.sqrt(((double)(-elem_a[0]) + mod) / 2.0));
                        resc.setComplexFloat(i, elem_res);
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)a;
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                double[] elem_res = new double[2];
                for (long i = 0L; i < length; ++i) {
                    double[] elem_a = _ac.getComplexDouble(i);
                    double mod = FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]);
                    elem_res[0] = FastMath.sqrt((elem_a[0] + mod) / 2.0);
                    elem_res[1] = FastMath.signum(elem_a[1]) * FastMath.sqrt((-elem_a[0] + mod) / 2.0);
                    resc.setComplexDouble(i, elem_res);
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] elem_res = new double[2];
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                double[] elem_a = _ac.getComplexDouble(k);
                                double mod = FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]);
                                elem_res[0] = FastMath.sqrt((elem_a[0] + mod) / 2.0);
                                elem_res[1] = FastMath.signum(elem_a[1]) * FastMath.sqrt((-elem_a[0] + mod) / 2.0);
                                resc.setComplexDouble(k, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    double[] elem_res = new double[2];
                    for (long i = 0L; i < length; ++i) {
                        double[] elem_a = _ac.getComplexDouble(i);
                        double mod = FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]);
                        elem_res[0] = FastMath.sqrt((elem_a[0] + mod) / 2.0);
                        elem_res[1] = FastMath.signum(elem_a[1]) * FastMath.sqrt((-elem_a[0] + mod) / 2.0);
                        resc.setComplexDouble(i, elem_res);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray log(LargeArray a) {
        LargeArrayType out_type = a.getType().isIntegerNumericType() ? LargeArrayType.FLOAT : a.getType();
        return LargeArrayArithmetics.log(a, out_type);
    }

    public static LargeArray log(final LargeArray a, LargeArrayType out_type) {
        if (a == null || !a.isNumeric()) {
            throw new IllegalArgumentException("a == null || !a.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a.length();
        if (a.isConstant()) {
            if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, FastMath.log(a.getDouble(0L)));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexLog(elem_a));
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexLog(elem_a));
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        final LargeArray res = LargeArrayUtils.create(out_type, length, false);
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    res.setDouble(i, FastMath.log(a.getDouble(i)));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                res.setDouble(k, FastMath.log(a.getDouble(k)));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        res.setDouble(i, FastMath.log(a.getDouble(i)));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)a;
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                float[] elem_res = new float[2];
                for (long i = 0L; i < length; ++i) {
                    float[] elem_a = _ac.getComplexFloat(i);
                    double mod = FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]);
                    double arg = FastMath.atan2(elem_a[1], elem_a[0]);
                    elem_res[0] = (float)FastMath.log(mod);
                    elem_res[1] = (float)arg;
                    resc.setComplexFloat(i, elem_res);
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] elem_res = new float[2];
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                float[] elem_a = _ac.getComplexFloat(k);
                                double mod = FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]);
                                double arg = FastMath.atan2(elem_a[1], elem_a[0]);
                                elem_res[0] = (float)FastMath.log(mod);
                                elem_res[1] = (float)arg;
                                resc.setComplexFloat(k, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    float[] elem_res = new float[2];
                    for (long i = 0L; i < length; ++i) {
                        float[] elem_a = _ac.getComplexFloat(i);
                        double mod = FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]);
                        double arg = FastMath.atan2(elem_a[1], elem_a[0]);
                        elem_res[0] = (float)FastMath.log(mod);
                        elem_res[1] = (float)arg;
                        resc.setComplexFloat(i, elem_res);
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)a;
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                double[] elem_res = new double[2];
                for (long i = 0L; i < length; ++i) {
                    double[] elem_a = _ac.getComplexDouble(i);
                    double mod = FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]);
                    double arg = FastMath.atan2(elem_a[1], elem_a[0]);
                    elem_res[0] = FastMath.log(mod);
                    elem_res[1] = arg;
                    resc.setComplexDouble(i, elem_res);
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] elem_res = new double[2];
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                double[] elem_a = _ac.getComplexDouble(k);
                                double mod = FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]);
                                double arg = FastMath.atan2(elem_a[1], elem_a[0]);
                                elem_res[0] = FastMath.log(mod);
                                elem_res[1] = arg;
                                resc.setComplexDouble(k, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    double[] elem_res = new double[2];
                    for (long i = 0L; i < length; ++i) {
                        double[] elem_a = _ac.getComplexDouble(i);
                        double mod = FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]);
                        double arg = FastMath.atan2(elem_a[1], elem_a[0]);
                        elem_res[0] = FastMath.log(mod);
                        elem_res[1] = arg;
                        resc.setComplexDouble(i, elem_res);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray log10(LargeArray a) {
        LargeArrayType out_type = a.getType().isIntegerNumericType() ? LargeArrayType.FLOAT : a.getType();
        return LargeArrayArithmetics.log10(a, out_type);
    }

    public static LargeArray log10(final LargeArray a, LargeArrayType out_type) {
        if (a == null || !a.isNumeric()) {
            throw new IllegalArgumentException("a == null || !a.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a.length();
        if (a.isConstant()) {
            if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, FastMath.log10(a.getDouble(0L)));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexLog10(elem_a));
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexLog10(elem_a));
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        final LargeArray res = LargeArrayUtils.create(out_type, length, false);
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    res.setDouble(i, FastMath.log10(a.getDouble(i)));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                res.setDouble(k, FastMath.log10(a.getDouble(k)));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        res.setDouble(i, FastMath.log10(a.getDouble(i)));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final double scale = FastMath.log(10.0);
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)a;
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                float[] elem_res = new float[2];
                for (long i = 0L; i < length; ++i) {
                    float[] elem_a = _ac.getComplexFloat(i);
                    double mod = FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]);
                    double arg = FastMath.atan2(elem_a[1], elem_a[0]) / scale;
                    elem_res[0] = (float)(FastMath.log(mod) / scale);
                    elem_res[1] = (float)arg;
                    resc.setComplexFloat(i, elem_res);
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] elem_res = new float[2];
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                float[] elem_a = _ac.getComplexFloat(k);
                                double mod = FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]);
                                double arg = FastMath.atan2(elem_a[1], elem_a[0]) / scale;
                                elem_res[0] = (float)(FastMath.log(mod) / scale);
                                elem_res[1] = (float)arg;
                                resc.setComplexFloat(k, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    float[] elem_res = new float[2];
                    for (long i = 0L; i < length; ++i) {
                        float[] elem_a = _ac.getComplexFloat(i);
                        double mod = FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]);
                        double arg = FastMath.atan2(elem_a[1], elem_a[0]) / scale;
                        elem_res[0] = (float)(FastMath.log(mod) / scale);
                        elem_res[1] = (float)arg;
                        resc.setComplexFloat(i, elem_res);
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final double scale = FastMath.log(10.0);
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)a;
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                double[] elem_res = new double[2];
                for (long i = 0L; i < length; ++i) {
                    double[] elem_a = _ac.getComplexDouble(i);
                    double mod = FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]);
                    double arg = FastMath.atan2(elem_a[1], elem_a[0]) / scale;
                    elem_res[0] = FastMath.log(mod) / scale;
                    elem_res[1] = arg;
                    resc.setComplexDouble(i, elem_res);
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] elem_res = new double[2];
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                double[] elem_a = _ac.getComplexDouble(k);
                                double mod = FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]);
                                double arg = FastMath.atan2(elem_a[1], elem_a[0]) / scale;
                                elem_res[0] = FastMath.log(mod) / scale;
                                elem_res[1] = arg;
                                resc.setComplexDouble(k, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    double[] elem_res = new double[2];
                    for (long i = 0L; i < length; ++i) {
                        double[] elem_a = _ac.getComplexDouble(i);
                        double mod = FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]);
                        double arg = FastMath.atan2(elem_a[1], elem_a[0]) / scale;
                        elem_res[0] = FastMath.log(mod) / scale;
                        elem_res[1] = arg;
                        resc.setComplexDouble(i, elem_res);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray exp(LargeArray a) {
        LargeArrayType out_type = a.getType().isIntegerNumericType() ? LargeArrayType.FLOAT : a.getType();
        return LargeArrayArithmetics.exp(a, out_type);
    }

    public static LargeArray exp(final LargeArray a, LargeArrayType out_type) {
        if (a == null || !a.isNumeric()) {
            throw new IllegalArgumentException("a == null || !a.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a.length();
        if (a.isConstant()) {
            if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, FastMath.exp(a.getDouble(0L)));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexExp(elem_a));
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexExp(elem_a));
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        final LargeArray res = LargeArrayUtils.create(out_type, length, false);
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    res.setDouble(i, FastMath.exp(a.getDouble(i)));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                res.setDouble(k, FastMath.exp(a.getDouble(k)));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        res.setDouble(i, FastMath.exp(a.getDouble(i)));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)a;
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                float[] elem_res = new float[2];
                for (long i = 0L; i < length; ++i) {
                    float[] elem_a = _ac.getComplexFloat(i);
                    elem_res[0] = (float)(FastMath.exp(elem_a[0]) * FastMath.cos(elem_a[1]));
                    elem_res[1] = (float)(FastMath.exp(elem_a[0]) * FastMath.sin(elem_a[1]));
                    resc.setComplexFloat(i, elem_res);
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] elem_res = new float[2];
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                float[] elem_a = _ac.getComplexFloat(k);
                                elem_res[0] = (float)(FastMath.exp(elem_a[0]) * FastMath.cos(elem_a[1]));
                                elem_res[1] = (float)(FastMath.exp(elem_a[0]) * FastMath.sin(elem_a[1]));
                                resc.setComplexFloat(k, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    float[] elem_res = new float[2];
                    for (long i = 0L; i < length; ++i) {
                        float[] elem_a = _ac.getComplexFloat(i);
                        elem_res[0] = (float)(FastMath.exp(elem_a[0]) * FastMath.cos(elem_a[1]));
                        elem_res[1] = (float)(FastMath.exp(elem_a[0]) * FastMath.sin(elem_a[1]));
                        resc.setComplexFloat(i, elem_res);
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)a;
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                double[] elem_res = new double[2];
                for (long i = 0L; i < length; ++i) {
                    double[] elem_a = _ac.getComplexDouble(i);
                    elem_res[0] = FastMath.exp(elem_a[0]) * FastMath.cos(elem_a[1]);
                    elem_res[1] = FastMath.exp(elem_a[0]) * FastMath.sin(elem_a[1]);
                    resc.setComplexDouble(i, elem_res);
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] elem_res = new double[2];
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                double[] elem_a = _ac.getComplexDouble(k);
                                elem_res[0] = FastMath.exp(elem_a[0]) * FastMath.cos(elem_a[1]);
                                elem_res[1] = FastMath.exp(elem_a[0]) * FastMath.sin(elem_a[1]);
                                resc.setComplexDouble(k, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    double[] elem_res = new double[2];
                    for (long i = 0L; i < length; ++i) {
                        double[] elem_a = _ac.getComplexDouble(i);
                        elem_res[0] = FastMath.exp(elem_a[0]) * FastMath.cos(elem_a[1]);
                        elem_res[1] = FastMath.exp(elem_a[0]) * FastMath.sin(elem_a[1]);
                        resc.setComplexDouble(i, elem_res);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray abs(LargeArray a) {
        LargeArrayType out_type = a.getType() == LargeArrayType.COMPLEX_FLOAT ? LargeArrayType.FLOAT : (a.getType() == LargeArrayType.COMPLEX_DOUBLE ? LargeArrayType.DOUBLE : a.getType());
        return LargeArrayArithmetics.abs(a, out_type);
    }

    public static LargeArray abs(final LargeArray a, LargeArrayType out_type) {
        if (a == null || !a.isNumeric()) {
            throw new IllegalArgumentException("a == null || !a.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a.length();
        if (a.isConstant()) {
            if (out_type.isIntegerNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, FastMath.abs(a.getLong(0L)));
            }
            if (out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, FastMath.abs(a.getDouble(0L)));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, Float.valueOf(LargeArrayArithmetics.complexAbs(elem_a)));
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexAbs(elem_a));
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        final LargeArray res = LargeArrayUtils.create(out_type, length, false);
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (a.getType().isIntegerNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    res.setDouble(i, FastMath.abs(a.getDouble(i)));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                res.setLong(k, FastMath.abs(a.getLong(k)));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        res.setDouble(i, FastMath.abs(a.getDouble(i)));
                    }
                }
            }
        } else if (a.getType().isRealNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    res.setDouble(i, FastMath.abs(a.getDouble(i)));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                res.setDouble(k, FastMath.abs(a.getDouble(k)));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        res.setDouble(i, FastMath.abs(a.getDouble(i)));
                    }
                }
            }
        } else if (a.getType() == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)a;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    float[] elem_a = _ac.getComplexFloat(i);
                    res.setFloat(i, (float)FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                float[] elem_a = _ac.getComplexFloat(k);
                                res.setFloat(k, (float)FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        float[] elem_a = _ac.getComplexFloat(i);
                        res.setFloat(i, (float)FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]));
                    }
                }
            }
        } else if (a.getType() == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)a;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    double[] elem_a = _ac.getComplexDouble(i);
                    res.setDouble(i, FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                double[] elem_a = _ac.getComplexDouble(k);
                                res.setDouble(k, FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        double[] elem_a = _ac.getComplexDouble(i);
                        res.setDouble(i, FastMath.sqrt(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]));
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray sin(LargeArray a) {
        LargeArrayType out_type = a.getType().isIntegerNumericType() ? LargeArrayType.FLOAT : a.getType();
        return LargeArrayArithmetics.sin(a, out_type);
    }

    public static LargeArray sin(final LargeArray a, LargeArrayType out_type) {
        if (a == null || !a.isNumeric()) {
            throw new IllegalArgumentException("a == null || !a.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a.length();
        if (a.isConstant()) {
            if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, FastMath.sin(a.getDouble(0L)));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexSin(elem_a));
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexSin(elem_a));
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        final LargeArray res = LargeArrayUtils.create(out_type, length, false);
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    res.setDouble(i, FastMath.sin(a.getDouble(i)));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                res.setDouble(k, FastMath.sin(a.getDouble(k)));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        res.setDouble(i, FastMath.sin(a.getDouble(i)));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)a;
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                float[] elem_res = new float[2];
                for (long i = 0L; i < length; ++i) {
                    float[] elem_a = _ac.getComplexFloat(i);
                    elem_res[0] = (float)(FastMath.sin(elem_a[0]) * FastMath.cosh(elem_a[1]));
                    elem_res[1] = (float)(FastMath.cos(elem_a[0]) * FastMath.sinh(elem_a[1]));
                    resc.setComplexFloat(i, elem_res);
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] elem_res = new float[2];
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                float[] elem_a = _ac.getComplexFloat(k);
                                elem_res[0] = (float)(FastMath.sin(elem_a[0]) * FastMath.cosh(elem_a[1]));
                                elem_res[1] = (float)(FastMath.cos(elem_a[0]) * FastMath.sinh(elem_a[1]));
                                resc.setComplexFloat(k, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    float[] elem_res = new float[2];
                    for (long i = 0L; i < length; ++i) {
                        float[] elem_a = _ac.getComplexFloat(i);
                        elem_res[0] = (float)(FastMath.sin(elem_a[0]) * FastMath.cosh(elem_a[1]));
                        elem_res[1] = (float)(FastMath.cos(elem_a[0]) * FastMath.sinh(elem_a[1]));
                        resc.setComplexFloat(i, elem_res);
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)a;
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                double[] elem_res = new double[2];
                for (long i = 0L; i < length; ++i) {
                    double[] elem_a = _ac.getComplexDouble(i);
                    elem_res[0] = FastMath.sin(elem_a[0]) * FastMath.cosh(elem_a[1]);
                    elem_res[1] = FastMath.cos(elem_a[0]) * FastMath.sinh(elem_a[1]);
                    resc.setComplexDouble(i, elem_res);
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] elem_res = new double[2];
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                double[] elem_a = _ac.getComplexDouble(k);
                                elem_res[0] = FastMath.sin(elem_a[0]) * FastMath.cosh(elem_a[1]);
                                elem_res[1] = FastMath.cos(elem_a[0]) * FastMath.sinh(elem_a[1]);
                                resc.setComplexDouble(k, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    double[] elem_res = new double[2];
                    for (long i = 0L; i < length; ++i) {
                        double[] elem_a = _ac.getComplexDouble(i);
                        elem_res[0] = FastMath.sin(elem_a[0]) * FastMath.cosh(elem_a[1]);
                        elem_res[1] = FastMath.cos(elem_a[0]) * FastMath.sinh(elem_a[1]);
                        resc.setComplexDouble(i, elem_res);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray cos(LargeArray a) {
        LargeArrayType out_type = a.getType().isIntegerNumericType() ? LargeArrayType.FLOAT : a.getType();
        return LargeArrayArithmetics.cos(a, out_type);
    }

    public static LargeArray cos(final LargeArray a, LargeArrayType out_type) {
        if (a == null || !a.isNumeric()) {
            throw new IllegalArgumentException("a == null || !a.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a.length();
        if (a.isConstant()) {
            if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, FastMath.cos(a.getDouble(0L)));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexCos(elem_a));
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexCos(elem_a));
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        final LargeArray res = LargeArrayUtils.create(out_type, length, false);
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    res.setDouble(i, FastMath.cos(a.getDouble(i)));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                res.setDouble(k, FastMath.cos(a.getDouble(k)));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        res.setDouble(i, FastMath.cos(a.getDouble(i)));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)a;
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                float[] elem_res = new float[2];
                for (long i = 0L; i < length; ++i) {
                    float[] elem_a = _ac.getComplexFloat(i);
                    elem_res[0] = (float)(FastMath.cos(elem_a[0]) * FastMath.cosh(elem_a[1]));
                    elem_res[1] = (float)(-FastMath.sin(elem_a[0]) * FastMath.sinh(elem_a[1]));
                    resc.setComplexFloat(i, elem_res);
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] elem_res = new float[2];
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                float[] elem_a = _ac.getComplexFloat(k);
                                elem_res[0] = (float)(FastMath.cos(elem_a[0]) * FastMath.cosh(elem_a[1]));
                                elem_res[1] = (float)(-FastMath.sin(elem_a[0]) * FastMath.sinh(elem_a[1]));
                                resc.setComplexFloat(k, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    float[] elem_res = new float[2];
                    for (long i = 0L; i < length; ++i) {
                        float[] elem_a = _ac.getComplexFloat(i);
                        elem_res[0] = (float)(FastMath.cos(elem_a[0]) * FastMath.cosh(elem_a[1]));
                        elem_res[1] = (float)(-FastMath.sin(elem_a[0]) * FastMath.sinh(elem_a[1]));
                        resc.setComplexFloat(i, elem_res);
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)a;
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                double[] elem_res = new double[2];
                for (long i = 0L; i < length; ++i) {
                    double[] elem_a = _ac.getComplexDouble(i);
                    elem_res[0] = FastMath.cos(elem_a[0]) * FastMath.cosh(elem_a[1]);
                    elem_res[1] = -FastMath.sin(elem_a[0]) * FastMath.sinh(elem_a[1]);
                    resc.setComplexDouble(i, elem_res);
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] elem_res = new double[2];
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                double[] elem_a = _ac.getComplexDouble(k);
                                elem_res[0] = FastMath.cos(elem_a[0]) * FastMath.cosh(elem_a[1]);
                                elem_res[1] = -FastMath.sin(elem_a[0]) * FastMath.sinh(elem_a[1]);
                                resc.setComplexDouble(k, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    double[] elem_res = new double[2];
                    for (long i = 0L; i < length; ++i) {
                        double[] elem_a = _ac.getComplexDouble(i);
                        elem_res[0] = FastMath.cos(elem_a[0]) * FastMath.cosh(elem_a[1]);
                        elem_res[1] = -FastMath.sin(elem_a[0]) * FastMath.sinh(elem_a[1]);
                        resc.setComplexDouble(i, elem_res);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray tan(LargeArray a) {
        LargeArrayType out_type = a.getType().isIntegerNumericType() ? LargeArrayType.FLOAT : a.getType();
        return LargeArrayArithmetics.tan(a, out_type);
    }

    public static LargeArray tan(final LargeArray a, LargeArrayType out_type) {
        if (a == null || !a.isNumeric()) {
            throw new IllegalArgumentException("a == null || !a.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a.length();
        if (a.isConstant()) {
            if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, FastMath.tan(a.getDouble(0L)));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexTan(elem_a));
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexTan(elem_a));
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        final LargeArray res = LargeArrayUtils.create(out_type, length, false);
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    res.setDouble(i, FastMath.tan(a.getDouble(i)));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                res.setDouble(k, FastMath.tan(a.getDouble(k)));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        res.setDouble(i, FastMath.tan(a.getDouble(i)));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)a;
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    float[] elem_a = _ac.getComplexFloat(i);
                    float[] s = LargeArrayArithmetics.complexSin(elem_a);
                    float[] c = LargeArrayArithmetics.complexCos(elem_a);
                    float[] elem_res = LargeArrayArithmetics.complexDiv(s, c);
                    resc.setComplexFloat(i, elem_res);
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                float[] elem_a = _ac.getComplexFloat(k);
                                float[] s = LargeArrayArithmetics.complexSin(elem_a);
                                float[] c = LargeArrayArithmetics.complexCos(elem_a);
                                float[] elem_res = LargeArrayArithmetics.complexDiv(s, c);
                                resc.setComplexFloat(k, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        float[] elem_a = _ac.getComplexFloat(i);
                        float[] s = LargeArrayArithmetics.complexSin(elem_a);
                        float[] c = LargeArrayArithmetics.complexCos(elem_a);
                        float[] elem_res = LargeArrayArithmetics.complexDiv(s, c);
                        resc.setComplexFloat(i, elem_res);
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)a;
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    double[] elem_a = _ac.getComplexDouble(i);
                    double[] s = LargeArrayArithmetics.complexSin(elem_a);
                    double[] c = LargeArrayArithmetics.complexCos(elem_a);
                    double[] elem_res = LargeArrayArithmetics.complexDiv(s, c);
                    resc.setComplexDouble(i, elem_res);
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                double[] elem_a = _ac.getComplexDouble(k);
                                double[] s = LargeArrayArithmetics.complexSin(elem_a);
                                double[] c = LargeArrayArithmetics.complexCos(elem_a);
                                double[] elem_res = LargeArrayArithmetics.complexDiv(s, c);
                                resc.setComplexDouble(k, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        double[] elem_a = _ac.getComplexDouble(i);
                        double[] s = LargeArrayArithmetics.complexSin(elem_a);
                        double[] c = LargeArrayArithmetics.complexCos(elem_a);
                        double[] elem_res = LargeArrayArithmetics.complexDiv(s, c);
                        resc.setComplexDouble(i, elem_res);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray asin(LargeArray a) {
        LargeArrayType out_type = a.getType().isIntegerNumericType() ? LargeArrayType.FLOAT : a.getType();
        return LargeArrayArithmetics.asin(a, out_type);
    }

    public static LargeArray asin(final LargeArray a, LargeArrayType out_type) {
        if (a == null || !a.isNumeric()) {
            throw new IllegalArgumentException("a == null || !a.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a.length();
        if (a.isConstant()) {
            if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, FastMath.asin(a.getDouble(0L)));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexAsin(elem_a));
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexAsin(elem_a));
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        final LargeArray res = LargeArrayUtils.create(out_type, length, false);
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    res.setDouble(i, FastMath.asin(a.getDouble(i)));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                res.setDouble(k, FastMath.asin(a.getDouble(k)));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        res.setDouble(i, FastMath.asin(a.getDouble(i)));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)a;
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    float[] elem_a = _ac.getComplexFloat(i);
                    resc.setComplexFloat(i, LargeArrayArithmetics.complexAsin(elem_a));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                float[] elem_a = _ac.getComplexFloat(k);
                                resc.setComplexFloat(k, LargeArrayArithmetics.complexAsin(elem_a));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        float[] elem_a = _ac.getComplexFloat(i);
                        resc.setComplexFloat(i, LargeArrayArithmetics.complexAsin(elem_a));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)a;
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    double[] elem_a = _ac.getComplexDouble(i);
                    resc.setComplexDouble(i, LargeArrayArithmetics.complexAsin(elem_a));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                double[] elem_a = _ac.getComplexDouble(k);
                                resc.setComplexDouble(k, LargeArrayArithmetics.complexAsin(elem_a));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        double[] elem_a = _ac.getComplexDouble(i);
                        resc.setComplexDouble(i, LargeArrayArithmetics.complexAsin(elem_a));
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray acos(LargeArray a) {
        LargeArrayType out_type = a.getType().isIntegerNumericType() ? LargeArrayType.FLOAT : a.getType();
        return LargeArrayArithmetics.acos(a, out_type);
    }

    public static LargeArray acos(final LargeArray a, LargeArrayType out_type) {
        if (a == null || !a.isNumeric()) {
            throw new IllegalArgumentException("a == null || !a.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a.length();
        if (a.isConstant()) {
            if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, FastMath.acos(a.getDouble(0L)));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexAcos(elem_a));
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexAcos(elem_a));
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        final LargeArray res = LargeArrayUtils.create(out_type, length, false);
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    res.setDouble(i, FastMath.acos(a.getDouble(i)));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                res.setDouble(k, FastMath.acos(a.getDouble(k)));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        res.setDouble(i, FastMath.acos(a.getDouble(i)));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)a;
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    float[] elem_a = _ac.getComplexFloat(i);
                    resc.setComplexFloat(i, LargeArrayArithmetics.complexAcos(elem_a));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                float[] elem_a = _ac.getComplexFloat(k);
                                resc.setComplexFloat(k, LargeArrayArithmetics.complexAcos(elem_a));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        float[] elem_a = _ac.getComplexFloat(i);
                        resc.setComplexFloat(i, LargeArrayArithmetics.complexAcos(elem_a));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)a;
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    double[] elem_a = _ac.getComplexDouble(i);
                    resc.setComplexDouble(i, LargeArrayArithmetics.complexAcos(elem_a));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                double[] elem_a = _ac.getComplexDouble(k);
                                resc.setComplexDouble(k, LargeArrayArithmetics.complexAcos(elem_a));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        double[] elem_a = _ac.getComplexDouble(i);
                        resc.setComplexDouble(i, LargeArrayArithmetics.complexAcos(elem_a));
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray atan(LargeArray a) {
        LargeArrayType out_type = a.getType().isIntegerNumericType() ? LargeArrayType.FLOAT : a.getType();
        return LargeArrayArithmetics.atan(a, out_type);
    }

    public static LargeArray atan(final LargeArray a, LargeArrayType out_type) {
        if (a == null || !a.isNumeric()) {
            throw new IllegalArgumentException("a == null || !a.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a.length();
        if (a.isConstant()) {
            if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, FastMath.atan(a.getDouble(0L)));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexAtan(elem_a));
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexAtan(elem_a));
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        final LargeArray res = LargeArrayUtils.create(out_type, length, false);
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    res.setDouble(i, FastMath.atan(a.getDouble(i)));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                res.setDouble(k, FastMath.atan(a.getDouble(k)));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        res.setDouble(i, FastMath.atan(a.getDouble(i)));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)a;
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    float[] elem_a = _ac.getComplexFloat(i);
                    resc.setComplexFloat(i, LargeArrayArithmetics.complexAtan(elem_a));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                float[] elem_a = _ac.getComplexFloat(k);
                                resc.setComplexFloat(k, LargeArrayArithmetics.complexAtan(elem_a));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        float[] elem_a = _ac.getComplexFloat(i);
                        resc.setComplexFloat(i, LargeArrayArithmetics.complexAtan(elem_a));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)a;
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i = 0L; i < length; ++i) {
                    double[] elem_a = _ac.getComplexDouble(i);
                    resc.setComplexDouble(i, LargeArrayArithmetics.complexAtan(elem_a));
                }
            } else {
                long k = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                    threads[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k = firstIdx; k < lastIdx; ++k) {
                                double[] elem_a = _ac.getComplexDouble(k);
                                resc.setComplexDouble(k, LargeArrayArithmetics.complexAtan(elem_a));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i = 0L; i < length; ++i) {
                        double[] elem_a = _ac.getComplexDouble(i);
                        resc.setComplexDouble(i, LargeArrayArithmetics.complexAtan(elem_a));
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray signum(LargeArray a) {
        LargeArrayType out_type = LargeArrayType.BYTE;
        return LargeArrayArithmetics.signum(a, out_type);
    }

    public static LargeArray signum(final LargeArray a, LargeArrayType out_type) {
        if (a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE) {
            throw new IllegalArgumentException("a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a.length();
        if (a.isConstant()) {
            return LargeArrayUtils.createConstant(out_type, length, (byte)FastMath.signum(a.getDouble(0L)));
        }
        final LargeArray res = LargeArrayUtils.create(out_type, length, false);
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i = 0L; i < length; ++i) {
                res.setByte(i, (byte)FastMath.signum(a.getDouble(i)));
            }
        } else {
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            res.setByte(k, (byte)FastMath.signum(a.getDouble(k)));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long i = 0L; i < length; ++i) {
                    res.setByte(i, (byte)FastMath.signum(a.getDouble(i)));
                }
            }
        }
        return res;
    }
}

