/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.chunk;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkGroupWriter;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonAlignedChunkGroupWriterImpl
implements IChunkGroupWriter {
    private static final Logger LOG = LoggerFactory.getLogger(NonAlignedChunkGroupWriterImpl.class);
    private final String deviceId;
    private Map<String, ChunkWriterImpl> chunkWriters = new LinkedHashMap<String, ChunkWriterImpl>();
    private Map<String, Long> lastTimeMap = new HashMap<String, Long>();

    public NonAlignedChunkGroupWriterImpl(String deviceId) {
        this.deviceId = deviceId;
    }

    @Override
    public void tryToAddSeriesWriter(MeasurementSchema schema) {
        if (!this.chunkWriters.containsKey(schema.getMeasurementId())) {
            this.chunkWriters.put(schema.getMeasurementId(), new ChunkWriterImpl(schema));
        }
    }

    @Override
    public void tryToAddSeriesWriter(List<MeasurementSchema> schemas) {
        for (IMeasurementSchema iMeasurementSchema : schemas) {
            if (this.chunkWriters.containsKey(iMeasurementSchema.getMeasurementId())) continue;
            this.chunkWriters.put(iMeasurementSchema.getMeasurementId(), new ChunkWriterImpl(iMeasurementSchema));
        }
    }

    @Override
    public int write(long time, List<DataPoint> data) throws IOException, WriteProcessException {
        int pointCount = 0;
        for (DataPoint point : data) {
            this.checkIsHistoryData(point.getMeasurementId(), time);
            if (pointCount == 0) {
                ++pointCount;
            }
            point.writeTo(time, this.chunkWriters.get(point.getMeasurementId()));
            this.lastTimeMap.put(point.getMeasurementId(), time);
        }
        return pointCount;
    }

    @Override
    public int write(Tablet tablet) throws WriteProcessException {
        int maxPointCount = 0;
        List<MeasurementSchema> timeseries = tablet.getSchemas();
        for (int column = 0; column < timeseries.size(); ++column) {
            String measurementId = timeseries.get(column).getMeasurementId();
            TSDataType tsDataType = timeseries.get(column).getType();
            int pointCount = 0;
            for (int row = 0; row < tablet.rowSize; ++row) {
                if (tablet.bitMaps != null && tablet.bitMaps[column] != null && tablet.bitMaps[column].isMarked(row)) continue;
                long time = tablet.timestamps[row];
                this.checkIsHistoryData(measurementId, time);
                ++pointCount;
                switch (tsDataType) {
                    case INT32: {
                        this.chunkWriters.get(measurementId).write(time, ((int[])tablet.values[column])[row]);
                        break;
                    }
                    case INT64: {
                        this.chunkWriters.get(measurementId).write(time, ((long[])tablet.values[column])[row]);
                        break;
                    }
                    case FLOAT: {
                        this.chunkWriters.get(measurementId).write(time, ((float[])tablet.values[column])[row]);
                        break;
                    }
                    case DOUBLE: {
                        this.chunkWriters.get(measurementId).write(time, ((double[])tablet.values[column])[row]);
                        break;
                    }
                    case BOOLEAN: {
                        this.chunkWriters.get(measurementId).write(time, ((boolean[])tablet.values[column])[row]);
                        break;
                    }
                    case TEXT: {
                        this.chunkWriters.get(measurementId).write(time, ((Binary[])tablet.values[column])[row]);
                        break;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", new Object[]{tsDataType}));
                    }
                }
                this.lastTimeMap.put(measurementId, time);
            }
            maxPointCount = Math.max(pointCount, maxPointCount);
        }
        return maxPointCount;
    }

    @Override
    public long flushToFileWriter(TsFileIOWriter fileWriter) throws IOException {
        LOG.debug("start flush device id:{}", (Object)this.deviceId);
        this.sealAllChunks();
        long currentChunkGroupSize = this.getCurrentChunkGroupSize();
        for (IChunkWriter iChunkWriter : this.chunkWriters.values()) {
            iChunkWriter.writeToFileWriter(fileWriter);
        }
        return currentChunkGroupSize;
    }

    @Override
    public long updateMaxGroupMemSize() {
        long bufferSize = 0L;
        for (IChunkWriter iChunkWriter : this.chunkWriters.values()) {
            bufferSize += iChunkWriter.estimateMaxSeriesMemSize();
        }
        return bufferSize;
    }

    @Override
    public long getCurrentChunkGroupSize() {
        long size = 0L;
        for (IChunkWriter iChunkWriter : this.chunkWriters.values()) {
            size += iChunkWriter.getSerializedChunkSize();
        }
        return size;
    }

    private void sealAllChunks() {
        for (IChunkWriter iChunkWriter : this.chunkWriters.values()) {
            iChunkWriter.sealCurrentPage();
        }
    }

    private void checkIsHistoryData(String measurementId, long time) throws WriteProcessException {
        if (time <= this.lastTimeMap.getOrDefault(measurementId, -1L)) {
            throw new WriteProcessException("Not allowed to write out-of-order data in timeseries " + this.deviceId + "." + measurementId + ", time should later than " + this.lastTimeMap.get(measurementId));
        }
    }

    public Map<String, Long> getLastTimeMap() {
        return this.lastTimeMap;
    }

    public void setLastTimeMap(Map<String, Long> lastTimeMap) {
        this.lastTimeMap = lastTimeMap;
    }
}

