/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.utils;

import java.nio.ByteBuffer;

public class BitReader {
    private static final int BITS_IN_A_BYTE = 8;
    private static final byte[] MASKS = new byte[]{-1, 127, 63, 31, 15, 7, 3, 1};
    private final ByteBuffer buffer;
    private int bitCnt = 8;
    private byte cache = 0;

    public BitReader(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public long next(int len) {
        long ret = 0L;
        while (len > 0) {
            if (this.bitCnt == 8) {
                this.next();
            }
            int m = len + this.bitCnt >= 8 ? 8 - this.bitCnt : len;
            len -= m;
            ret <<= m;
            byte y = (byte)(this.cache & MASKS[this.bitCnt]);
            y = (byte)((y & 0xFF) >>> 8 - this.bitCnt - m);
            ret |= (long)(y & 0xFF);
            this.bitCnt += m;
        }
        return ret;
    }

    public byte[] nextBytes(int len) {
        byte[] ret = new byte[len];
        if (this.bitCnt == 8) {
            this.buffer.get(ret);
        } else {
            for (int i = 0; i < len; ++i) {
                ret[i] = (byte)this.next(8);
            }
        }
        return ret;
    }

    public void skip() {
        this.bitCnt = 8;
    }

    private void next() {
        this.cache = this.buffer.get();
        this.bitCnt = 0;
    }
}

