/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.PriorityQueue;
import org.apache.iotdb.tsfile.encoding.encoder.Encoder;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.BitConstructor;
import org.jtransforms.dct.DoubleDCT_1D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreqEncoder
extends Encoder {
    public static final String FREQ_ENCODING_SNR = "freq_encoding_snr";
    public static final String FREQ_ENCODING_BLOCK_SIZE = "freq_encoding_block_size";
    protected static final int BLOCK_DEFAULT_SIZE = 1024;
    protected static final double DEFAULT_SNR = 40.0;
    private static final Logger logger = LoggerFactory.getLogger(FreqEncoder.class);
    private int blockSize;
    protected int writeIndex = 0;
    private double threshold = 1.0E-4;
    private int beta;
    private double[] dataBuffer;
    private DoubleDCT_1D transformer;

    public FreqEncoder() {
        this(1024);
    }

    public FreqEncoder(int size) {
        this(size, 40.0);
    }

    public FreqEncoder(int size, double snr) {
        super(TSEncoding.FREQ);
        this.blockSize = size;
        this.transformer = new DoubleDCT_1D(this.blockSize);
        this.dataBuffer = new double[this.blockSize];
        snr = Math.max(snr, 0.0);
        this.threshold = Math.pow(10.0, -snr / 10.0);
    }

    @Override
    public void encode(double value, ByteArrayOutputStream out) {
        this.dataBuffer[this.writeIndex] = value;
        ++this.writeIndex;
        if (this.writeIndex == this.blockSize) {
            this.flush(out);
        }
    }

    @Override
    public void encode(float value, ByteArrayOutputStream out) {
        this.encode((double)value, out);
    }

    @Override
    public void encode(int value, ByteArrayOutputStream out) {
        this.encode((double)value, out);
    }

    @Override
    public void encode(long value, ByteArrayOutputStream out) {
        this.encode((double)value, out);
    }

    @Override
    public void flush(ByteArrayOutputStream out) {
        try {
            this.flushBlock(out);
        }
        catch (IOException e) {
            logger.error("flush data to stream failed!", e);
        }
    }

    @Override
    public int getOneItemMaxSize() {
        return 13;
    }

    @Override
    public long getMaxByteSize() {
        return 8 + 13 * this.writeIndex;
    }

    private void flushBlock(ByteArrayOutputStream out) throws IOException {
        if (this.writeIndex > 0) {
            this.dct();
            ArrayList<Point> list = this.selectPoints(this.dataBuffer);
            byte[] data = this.encodeBlock(list);
            out.write(data);
            this.writeIndex = 0;
        }
    }

    private void dct() {
        DoubleDCT_1D dct = this.writeIndex == this.blockSize ? this.transformer : new DoubleDCT_1D(this.writeIndex);
        dct.forward(this.dataBuffer, true);
    }

    private byte[] encodeBlock(ArrayList<Point> list) {
        int m = list.size();
        int[] index = new int[m];
        long[] value = new long[m];
        double eps = Math.pow(2.0, this.beta);
        for (int i = 0; i < m; ++i) {
            Point p = list.get(i);
            index[i] = p.getIndex();
            value[i] = Math.round(p.getValue() / eps);
        }
        BitConstructor constructor = new BitConstructor(9 + 13 * m);
        constructor.add(this.writeIndex, 16);
        constructor.add(m, 16);
        constructor.add(this.beta, 16);
        this.encodeIndex(index, constructor);
        this.encodeValue(value, constructor);
        constructor.pad();
        return constructor.toByteArray();
    }

    private void encodeIndex(int[] value, BitConstructor constructor) {
        int bitsWidth = this.getValueWidth(this.getValueWidth(this.writeIndex - 1));
        for (int i = 0; i < value.length; i += 8) {
            int j;
            int bits = 0;
            for (j = i; j < Math.min(value.length, i + 8); ++j) {
                bits = Math.max(bits, this.getValueWidth(value[j]));
            }
            constructor.add(bits, bitsWidth);
            for (j = i; j < Math.min(value.length, i + 8); ++j) {
                constructor.add(value[j], bits);
            }
        }
    }

    private void encodeValue(long[] value, BitConstructor constructor) {
        if (value.length == 0) {
            return;
        }
        int bits = this.getValueWidth(Math.abs(value[0]));
        constructor.add(bits, 8);
        long min = Math.abs(value[value.length - 1]);
        constructor.add(min, bits);
        for (int i = 0; i < value.length; ++i) {
            constructor.add(value[i] >= 0L ? 0L : 1L, 1);
            value[i] = Math.abs(value[i]) - min;
            constructor.add(value[i], bits);
            bits = this.getValueWidth(value[i]);
        }
    }

    private int getValueWidth(long x) {
        return 64 - Long.numberOfLeadingZeros(x);
    }

    private int initBeta(double sum2) {
        double temp = Math.sqrt(this.threshold * sum2 / (double)(this.writeIndex * this.writeIndex));
        return (int)Math.max((double)this.max2Power(temp), Math.log(sum2) / (2.0 * Math.log(2.0)) - 60.0);
    }

    private int max2Power(double x) {
        double ans = 1.0;
        int exponent = 0;
        if (x > 1.0) {
            while (ans * 2.0 <= x) {
                ans *= 2.0;
                ++exponent;
            }
        } else {
            while (ans > x) {
                ans /= 2.0;
                --exponent;
            }
        }
        return exponent;
    }

    private ArrayList<Point> selectPoints(double[] a) {
        Point point;
        double sum2 = 0.0;
        PriorityQueue<Point> queue = new PriorityQueue<Point>(this.writeIndex);
        for (int i = 0; i < this.writeIndex; ++i) {
            point = new Point(i, a[i]);
            queue.add(point);
            sum2 += point.getPower();
        }
        this.beta = this.initBeta(sum2);
        double systemError = sum2;
        ArrayList<Point> keepList = new ArrayList<Point>();
        int m = 0;
        double roundingError = 0.0;
        double reduceBits = Double.MAX_VALUE;
        boolean first = true;
        while (true) {
            double increaseBits;
            if (systemError + roundingError > this.threshold * sum2) {
                point = (Point)queue.poll();
                if (point == null) {
                    systemError = 0.0;
                } else {
                    keepList.add(point);
                    systemError -= point.getPower();
                    roundingError = Math.pow(2.0, this.beta * 2) * (double)keepList.size();
                    continue;
                }
            }
            if (reduceBits <= (increaseBits = this.estimateIncreaseBits(keepList, m)) || systemError + roundingError > this.threshold * sum2) {
                if (first) break;
                keepList = new ArrayList<Point>(keepList.subList(0, m));
                --this.beta;
                break;
            }
            first = false;
            m = keepList.size();
            reduceBits = m;
            ++this.beta;
            roundingError = Math.pow(2.0, this.beta * 2) * (double)m;
        }
        return keepList;
    }

    private double estimateIncreaseBits(ArrayList<Point> list, int m) {
        double bits = 0.0;
        double eps = Math.pow(2.0, this.beta);
        for (int i = m; i < list.size(); ++i) {
            bits += (double)this.getValueWidth(this.writeIndex - 1);
            bits += (double)this.getValueWidth(Math.round(Math.abs(list.get(i).getValue()) / eps));
            bits += 1.0;
        }
        return bits;
    }

    protected class Point
    implements Comparable<Point> {
        private final int index;
        private final double value;

        public Point(int index, double value) {
            this.index = index;
            this.value = value;
        }

        @Override
        public int compareTo(Point o) {
            return Double.compare(o.getPower(), this.getPower());
        }

        public int getIndex() {
            return this.index;
        }

        public double getValue() {
            return this.value;
        }

        public double getPower() {
            return this.value * this.value;
        }
    }
}

