/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.trigger;

import java.util.List;
import org.apache.iotdb.trigger.api.Trigger;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerTrigger
implements Trigger {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggerTrigger.class);

    @Override
    public boolean fire(Tablet tablet) throws Exception {
        List<MeasurementSchema> measurementSchemaList = tablet.getSchemas();
        int n = measurementSchemaList.size();
        for (int i = 0; i < n; ++i) {
            Object[] values;
            if (measurementSchemaList.get(i).getType().equals((Object)TSDataType.DOUBLE)) {
                for (double value : values = (double[])tablet.values[i]) {
                    if (!(value > 100.0)) continue;
                    LOGGER.info("Double type, trigger value > 100");
                }
                continue;
            }
            if (measurementSchemaList.get(i).getType().equals((Object)TSDataType.FLOAT)) {
                for (double value : values = (Object[])((float[])tablet.values[i])) {
                    if (!(value > 100.0f)) continue;
                    LOGGER.info("Float type, trigger value > 100");
                }
                continue;
            }
            if (measurementSchemaList.get(i).getType().equals((Object)TSDataType.INT64)) {
                for (double value : values = (Object[])((long[])tablet.values[i])) {
                    if (value <= -100L) continue;
                    LOGGER.info("Int64 type, trigger value > -100");
                }
                continue;
            }
            if (measurementSchemaList.get(i).getType().equals((Object)TSDataType.INT32)) {
                for (double value : values = (Object[])((int[])tablet.values[i])) {
                    if (value <= -100) continue;
                    LOGGER.info("Int32 type, trigger value > -100");
                }
                continue;
            }
            if (measurementSchemaList.get(i).getType().equals((Object)TSDataType.TEXT)) {
                for (double ignored : values = (Object[])((Binary[])tablet.values[i])) {
                    LOGGER.info("Text type, trigger Non empty");
                }
                continue;
            }
            if (!measurementSchemaList.get(i).getType().equals((Object)TSDataType.BOOLEAN)) continue;
            for (double ignored : values = (Object[])((boolean[])tablet.values[i])) {
                LOGGER.info("Boolean type, trigger fires");
            }
        }
        return true;
    }
}

