/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.trigger;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.db.engine.trigger.sink.alertmanager.AlertManagerConfiguration;
import org.apache.iotdb.db.engine.trigger.sink.alertmanager.AlertManagerEvent;
import org.apache.iotdb.db.engine.trigger.sink.alertmanager.AlertManagerHandler;
import org.apache.iotdb.trigger.api.Trigger;
import org.apache.iotdb.trigger.api.TriggerAttributes;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterAlertingExample
implements Trigger {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterAlertingExample.class);
    private final AlertManagerHandler alertManagerHandler = new AlertManagerHandler();
    private final AlertManagerConfiguration alertManagerConfiguration = new AlertManagerConfiguration("http://127.0.0.1:9093/api/v2/alerts");
    private String alertname;
    private final HashMap<String, String> labels = new HashMap();
    private final HashMap<String, String> annotations = new HashMap();

    @Override
    public void onCreate(TriggerAttributes attributes) throws Exception {
        this.alertname = "alert_test";
        this.labels.put("series", "root.ln.wf01.wt01.temperature");
        this.labels.put("value", "");
        this.labels.put("severity", "");
        this.annotations.put("summary", "high temperature");
        this.annotations.put("description", "{{.alertname}}: {{.series}} is {{.value}}");
        this.alertManagerHandler.open(this.alertManagerConfiguration);
    }

    @Override
    public void onDrop() throws IOException {
        this.alertManagerHandler.close();
    }

    @Override
    public boolean fire(Tablet tablet) throws Exception {
        List<MeasurementSchema> measurementSchemaList = tablet.getSchemas();
        int n = measurementSchemaList.size();
        for (int i = 0; i < n; ++i) {
            double[] values;
            if (!measurementSchemaList.get(i).getType().equals((Object)TSDataType.DOUBLE)) continue;
            for (double value : values = (double[])tablet.values[i]) {
                AlertManagerEvent alertManagerEvent;
                if (value > 100.0) {
                    LOGGER.info("trigger value > 100");
                    this.labels.put("value", String.valueOf(value));
                    this.labels.put("severity", "critical");
                    alertManagerEvent = new AlertManagerEvent(this.alertname, this.labels, this.annotations);
                    this.alertManagerHandler.onEvent(alertManagerEvent);
                    continue;
                }
                if (!(value > 50.0)) continue;
                LOGGER.info("trigger value > 50");
                this.labels.put("value", String.valueOf(value));
                this.labels.put("severity", "warning");
                alertManagerEvent = new AlertManagerEvent(this.alertname, this.labels, this.annotations);
                this.alertManagerHandler.onEvent(alertManagerEvent);
            }
        }
        return true;
    }
}

