/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.spark.db;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import org.apache.iotdb.jdbc.IoTDBJDBCResultSet;
import org.apache.iotdb.spark.db.Converter;
import org.apache.iotdb.spark.db.IoTDBOptions;
import org.apache.iotdb.spark.db.SQLConstant$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class Converter$ {
    public static Converter$ MODULE$;
    private final Logger logger;

    static {
        new Converter$();
    }

    private final Logger logger() {
        return this.logger;
    }

    public Object toSqlData(StructField field, String value) {
        Object object;
        if (value == null || value.equals(SQLConstant$.MODULE$.NULL_STR())) {
            return null;
        }
        DataType dataType = field.dataType();
        if (BooleanType$.MODULE$.equals(dataType)) {
            object = Boolean.valueOf(value);
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            object = BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(value)).toInt());
        } else if (LongType$.MODULE$.equals(dataType)) {
            object = BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(value)).toLong());
        } else if (FloatType$.MODULE$.equals(dataType)) {
            object = BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(value)).toFloat());
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            object = BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(value)).toDouble());
        } else if (StringType$.MODULE$.equals(dataType)) {
            object = value;
        } else {
            throw new UnsupportedOperationException(new StringBuilder(17).append("Unsupported type ").append(dataType).toString());
        }
        Boolean r = object;
        return r;
    }

    public StructType toSparkSchema(IoTDBOptions options) {
        StructType structType;
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        Connection sqlConn = DriverManager.getConnection(options.url(), options.user(), options.password());
        Statement sqlStatement = sqlConn.createStatement();
        boolean hasResultSet = sqlStatement.execute(options.sql());
        ListBuffer fields = new ListBuffer();
        if (hasResultSet) {
            ResultSet resultSet = sqlStatement.getResultSet();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            boolean printTimestamp = !((IoTDBJDBCResultSet)resultSet).isIgnoreTimeStamp();
            Object object = printTimestamp ? fields.$plus$eq((Object)new StructField(SQLConstant$.MODULE$.TIMESTAMP_STR(), (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4())) : BoxedUnit.UNIT;
            int colCount = resultSetMetaData.getColumnCount();
            int startIndex = 2;
            if (!"Time".equals(resultSetMetaData.getColumnName(1))) {
                startIndex = 1;
            }
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(startIndex), colCount).foreach((Function1 & Serializable & scala.Serializable)i -> Converter$.$anonfun$toSparkSchema$1(fields, resultSetMetaData, BoxesRunTime.unboxToInt((Object)i)));
            structType = StructType$.MODULE$.apply((Seq)fields.toList());
        } else {
            structType = StructType$.MODULE$.apply((Seq)fields);
        }
        return structType;
    }

    public static final /* synthetic */ ListBuffer $anonfun$toSparkSchema$1(ListBuffer fields$1, ResultSetMetaData resultSetMetaData$1, int i) {
        BooleanType$ booleanType$;
        String string = resultSetMetaData$1.getColumnLabel(i);
        int n = resultSetMetaData$1.getColumnType(i);
        switch (n) {
            case 16: {
                booleanType$ = BooleanType$.MODULE$;
                break;
            }
            case 4: {
                booleanType$ = IntegerType$.MODULE$;
                break;
            }
            case -5: {
                booleanType$ = LongType$.MODULE$;
                break;
            }
            case 6: {
                booleanType$ = FloatType$.MODULE$;
                break;
            }
            case 8: {
                booleanType$ = DoubleType$.MODULE$;
                break;
            }
            case 12: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            default: {
                throw new UnsupportedOperationException(new StringBuilder(17).append("Unsupported type ").append(n).toString());
            }
        }
        return fields$1.$plus$eq((Object)new StructField(string, (DataType)booleanType$, true, StructField$.MODULE$.apply$default$4()));
    }

    private Converter$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(Converter.class);
    }
}

